package cn.smarthse.township.manage.vo.company;

import cn.smarthse.common.util.date.DateUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 企业端——巡查列表
 *
 * @author ShenZQ
 * @since 2023/3/9 13:26
 */
@Data
public class CompanyPatrolIndexDataVo implements Serializable {

    private static final long serialVersionUID = 163821645875977262L;

    /**
     * 巡查记录id
     */
    private Long id;

    /**
     * 巡查名称
     */
    private String patrolName;

    /**
     * 巡查年份
     */
    private Integer year;

    /**
     * 单位名称
     */
    private String unitName;

    /**
     * 巡查人
     */
    private String patrolPeople;

    /**
     * 巡查时间
     */
    private Date patrolTime;
    private String patrolTimeStr;

    /**
     * 巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)
     */
    private Integer patrolStatus;

    /**
     * 中止类型 StopTypeEnums
     */
    private Integer stopType;

    /**
     * 风险整改信息数量
     */
    private CompanyPatrolOverdueInformationVo companyPatrolOverdueInformationVo;

    public String getPatrolTimeStr() {
        if (Objects.isNull(this.patrolTime)) {
            return "-";
        } else {
            return DateUtil.format(this.patrolTime, "yyyy/MM/dd");
        }
    }

    public String getPatrolTimeStrByShortLine() {
        if (Objects.isNull(this.patrolTime)) {
            return "-";
        } else {
            return DateUtil.format(this.patrolTime, "yyyy-MM-dd");
        }
    }
}
