package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 乡镇协管工作档案历记录
 */
@Data
public class WorkFileHistoryVo implements Serializable {
    private static final long serialVersionUID = 5632455259415123490L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "批次编码")
    private String batchCode;

    @ApiModelProperty(value = "区域id父id")
    private Long parentId;

    @ApiModelProperty(value = "区域id")
    private Long areaId;

    @ApiModelProperty(value = "区域等级")
    private Integer areaLevel;

    @ApiModelProperty(value = "区域名称")
    private String areaName;

    @ApiModelProperty(value = "统计所属年份")
    private Integer year;

    @ApiModelProperty(value = "统计截止日期")
    private Date deadline;

    @ApiModelProperty(value = "入档时间")
    private Date entryTime;

    @ApiModelProperty(value = "卡片类型（-1 OR NULL:全部，0-非直属，1-省直属，2-市属）")
    private Integer belongType;

    @ApiModelProperty(value = "自查表提交率")
    private String selfInspectionRate;

    @ApiModelProperty(value = "巡查化解率(整改率)分子")
    private String rectificationRate1;

    @ApiModelProperty(value = "巡查化解率(整改率)分母")
    private String rectificationRate2;

    @ApiModelProperty(value = "巡查化解率(整改率)")
    private String rectificationRate;

    @ApiModelProperty(value = "已产生风险总数")
    private Integer riskNum;

    @ApiModelProperty(value = "待验收风险数")
    private Integer toBeAccepted;

    @ApiModelProperty(value = "待整改风险数")
    private Integer toBeRectifiedNum;

    @ApiModelProperty(value = "红色预警风险数")
    private Integer redAlertNum;

    @ApiModelProperty(value = "启动执法风险数")
    private Integer startEnforcementNum;

    @ApiModelProperty(value = "拥有协管员的下级区域数")
    private Integer hasStaffAreaNum;

    @ApiModelProperty(value = "下级区域数")
    private Integer subAreaNum;

    @ApiModelProperty(value = "公司数量(不包括<3")
    private Integer companyNum;

    @ApiModelProperty(value = "公司数量(正常营业)(不包括<3)")
    private Integer normalCompanyNum;

    @ApiModelProperty(value = "公司数量(暂停营业)(不包括<3)")
    private Integer suspensionCompanyNum;

    @ApiModelProperty(value = "已经巡查公司数量(不包括<3)")
    private Integer patroledCompanyNum;

    @ApiModelProperty(value = "已经巡查公司数量(正常营业)(不包括<3)")
    private Integer patroledNormalCompanyNum;

    @ApiModelProperty(value = "已经巡查公司数量(暂停营业)(不包括<3)")
    private Integer patroledSuspensionCompanyNum;

    @ApiModelProperty(value = "所有地址未精确到街道的公司数量(包括<3)")
    private Integer allLt4AreaCompanyNum;

    @ApiModelProperty(value = "巡查覆盖率(正常营业)(不包括<3)")
    private String patroaledCompanyRate;

    @ApiModelProperty(value = "巡查覆盖率(正常营业)(不包括<3)")
    private String normalPatroaledCompanyRate;

    @ApiModelProperty(value = "巡查覆盖率(暂停营业)(不包括<3)")
    private String suspensionPatroaledCompanyRate;

    @ApiModelProperty(value = "最近一次巡查时间")
    private Date lastPatrolTime;

    @ApiModelProperty(value = "最近一次更新时间")
    private Date lastUpdateTime;
}
