package cn.smarthse.township.manage.vo.admin;

import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName StreetCompanyStatisticsVo
 * @Description 街道公司巡查统计
 * @Author ChenLiang
 * @ModifyDate 2023/3/10 15:03
 */
@Data
public class StreetCompanyStatisticslVo implements Serializable {
    private static final long serialVersionUID = 1314303205621755787L;
    @ApiModelProperty("公司id")
    private Long cid;
    @ApiModelProperty("公司名称")
    private String name;
    @ApiModelProperty("企业社会信用代码")
    private String unifiedSocialCc;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("公司地址")
    private String registerAddress;
    @ApiModelProperty("营业状态")
    private Integer businessState;
    @ApiModelProperty("营业状态")
    private Integer townshipStopType;
    @ApiModelProperty("协管中止类型[仅用于单位信息变更提醒](0-无；1-拟暂停；2-拟关闭；3-拟迁移；4-拟恢复)")
    private String townshipStopTypeName;
    @ApiModelProperty("营业状态名称")
    private String businessStateName;
    @ApiModelProperty("风险类别")
    private Integer grade;
    @ApiModelProperty("风险类别名称")
    private String gradeName;
    @ApiModelProperty("风险等级")
    private Integer judgeLevel;
    @ApiModelProperty("风险等级名称")
    private String judgeLevelName;
    @ApiModelProperty("负责人名称")
    private String mainLeaderName;
    @ApiModelProperty("负责人手机")
    private String mainLeaderTel;
    @ApiModelProperty("管理员名称")
    private String occManagerName;
    @ApiModelProperty("管理员手机")
    private String occManagerTel;
    @ApiModelProperty("风险数量")
    private String riskNum;
    @ApiModelProperty("待整改风险数")
    private String toBeRectifiedNum;
    @ApiModelProperty("待验收风险数")
    private String toBeAcceptedNum;
    @ApiModelProperty("红色预警风险数")
    private String redAlertNum;
    @ApiModelProperty("启动执法风险数")
    private String startEnforcementNum;
    @ApiModelProperty("超期未整改风险数")
    private String overdueNotRectifiedNum;
    @ApiModelProperty("超期未验收数")
    private String overdueNotAcceptedNum;
    @ApiModelProperty("当年巡查次数")
    private String curYearPotalNum;
    @ApiModelProperty("巡查次数")
    private String potalNum;
    @ApiModelProperty("上一次巡查时间")
    private Date lastPatrolTime;

    public String getGradeName() {
        if (this.grade == null) {
            return "";
        }
        return CompanyGradeEnum.getName(this.grade.byteValue());
    }

    public String getBusinessStateName() {
        if (this.businessState == null) {
            return "";
        }
        return CompanyBusinessState.getName(this.businessState);
    }

    public String getJudgeLevelName() {
        if (this.judgeLevel == null) {
            return "";
        }
        return JudgeResultLevelEnum.getNameByCode(this.judgeLevel);
    }

    public String getTownshipStopTypeName() {
        if (this.townshipStopType == null) {
            return "";
        }
        return StopTypeEnums.getNameByCode(this.townshipStopType);
    }

}