package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName StreetCompanyStatisticsVo
 * @Description 街道公司巡查统计
 * @Author ChenLiang
 * @ModifyDate 2023/3/10 15:03
 */
@Data
public class  StreetCompanyStatisticsTotalVo implements Serializable {
    private static final long serialVersionUID = -444549077306746227L;

    @ApiModelProperty("已巡查企业数")
    private Integer patroledNum = 0;
    @ApiModelProperty("已巡查企业数(正常营业)")
    private Integer patroledNormalNum = 0;
    @ApiModelProperty("已巡查企业数（暂停营业）")
    private Integer patroledSuspensionNum = 0;

    @ApiModelProperty("总企业数")
    private Integer totalNum = 0;
    @ApiModelProperty("总企业数（正常营业）")
    private Integer totalNormalNum = 0;
    @ApiModelProperty("总企业数（暂停营业）")
    private Integer totalSuspensionNum = 0;

    @ApiModelProperty("未巡查企业数")
    private Integer notPatroledNum = 0;
    @ApiModelProperty("未巡查企业数（正常营业）")
    private Integer notPatroledNormalNum = 0;
    @ApiModelProperty("未巡查企业数（暂停营业）")
    private Integer notPatroledSuspensionNum = 0;

//    @ApiModelProperty("已完成巡查企业业数")
//    private Integer completedNum;

//    @ApiModelProperty("未巡完成查企业数")
//    private Integer unaccomplishedNum;

    @ApiModelProperty("最近一次巡查时间")
    private Date lastUpdateTime;

//    public Integer getPatroledNum(){
//        return totalNum - notPatroledNum;
//    }
}
