package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Data;

/**
 * 监管：首页 乡镇协管统计
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/10/9 15:21
 */
@Data
public class HomeSupervisionTownshipVo implements Serializable {

    private static final long serialVersionUID = 7247018592405266602L;
    /**
     *
     */
    private Long areaId;
    private Long areaId1;
    private Long areaId2;
    private Long areaId3;
    private Long areaId4;
    private String areaName;
    /**
     * 巡查化解率
     */
    private String rate;
    /**
     * 巡查化解率
     */
    private BigDecimal rateNum;
    /**
     * 本地市排名
     */
    private Integer rankCity;
    /**
     * 省内排名
     */
    private Integer rankProvince;
    /**
     * 已化解风险 （百分比的分子）
     */
    private Integer reformedNum = 0;
    /**
     * 风险数 （百分比的分母）
     */
    private Integer riskNum = 0;
    /**
     * 未巡查企业数（正常营业）（家）
     */
    private Integer unPatrolCompany1;
    /**
     * 未巡查企业数（暂停营业）（家）
     */
    private Integer unPatrolCompany2;
    /**
     * 公司数量(正常营业)(不包括<3)
     */
    private Integer normalCompanyNum = 0;
    /**
     * 公司数量(暂停营业)(不包括<3)")
     */
    private Integer suspensionCompanyNum = 0;
    /**
     * 应配备协管员镇街数（家）
     */
    private Integer street;
    /**
     * 已配备协管员镇街数（家）
     */
    private Integer street2;
    /**
     * 街道协管员人数
     */
    private Integer peopleNum;

    public String getRate() {
        BigDecimal result = this.rateProcessing(this.reformedNum, riskNum);
        return result == null ? "-" : result + "%";
    }

    public BigDecimal getRateNum() {
        return this.rateProcessing(this.reformedNum, riskNum);
    }

    public BigDecimal rateProcessing(int a, int b) {

        boolean aFlag = (a == 0);
        boolean bFlag = (b == 0);

        if (aFlag) return new BigDecimal("0.00");
        if (bFlag) return null;

        BigDecimal aDecimal = new BigDecimal(a);
        BigDecimal bDecimal = new BigDecimal(b);
        return aDecimal.multiply(new BigDecimal(100)).divide(bDecimal, 2, RoundingMode.HALF_UP);
    }

    public HomeSupervisionTownshipVo() {

    }
    public HomeSupervisionTownshipVo(Long areaId, Long areaId1, Long areaId2, BigDecimal rateNum) {
        this.areaId = areaId;
        this.areaId1 = areaId1;
        this.areaId2 = areaId2;
        this.rateNum = rateNum;
    }

    public void setRankCity(Integer rankCity) {
        //前端需要没有排名时不返回值
        this.rankCity = (rankCity == null || rankCity == -1 ? null : rankCity);
    }

    public void setRankProvince(Integer rankProvince) {
        this.rankProvince = (rankProvince == null || rankProvince == -1 ? null : rankProvince);
    }
}
