package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.text.NumberFormat;

/**
 * @Classname EnterpriseRiskDistributionVo
 * @Description 企业风险数量分布情况
 * @Date 2023/10/10 14:13
 * @Author chenliang
 */
@Data
public class EnterpriseRiskDistributionVo implements Serializable {
    private static final long serialVersionUID = -9081677119322230967L;
    @ApiModelProperty("1个风险公司数量")
    private Integer oneRiskCompanyNum = 0;
    @ApiModelProperty("2个风险公司数量")
    private Integer twoRiskCompanyNum = 0;
    @ApiModelProperty("3个风险公司数量")
    private Integer threeRiskCompanyNum = 0;
    @ApiModelProperty("4个风险公司数量")
    private Integer fourRiskCompanyNum = 0;
    @ApiModelProperty("5个风险公司数量")
    private Integer fiveRiskCompanyNum = 0;
    @ApiModelProperty("6个风险公司数量")
    private Integer sixRiskCompanyNum = 0;
    @ApiModelProperty("7个风险公司数量")
    private Integer sevenRiskCompanyNum = 0;
    @ApiModelProperty("8个风险公司数量")
    private Integer eightRiskCompanyNum = 0;

    @ApiModelProperty("1个风险公司数量占比")
    private String oneRiskCompanyNumRate;
    @ApiModelProperty("2个风险公司数量占比")
    private String twoRiskCompanyNumRate;
    @ApiModelProperty("3个风险公司数量占比")
    private String threeRiskCompanyNumRate;
    @ApiModelProperty("4个风险公司数量占比")
    private String fourRiskCompanyNumRate;
    @ApiModelProperty("5个风险公司数量占比")
    private String fiveRiskCompanyNumRate;
    @ApiModelProperty("6个风险公司数量占比")
    private String sixRiskCompanyNumRate;
    @ApiModelProperty("7个风险公司数量占比")
    private String sevenRiskCompanyNumRate;
    @ApiModelProperty("8个风险公司数量占比")
    private String eightRiskCompanyNumRate;

    public String getOneRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) oneRiskCompanyNum / total();
            return nf.format(result);
        }
    }

    public String getTwoRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) twoRiskCompanyNum / total();
            return nf.format(result);
        }
    }

    public String getThreeRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) threeRiskCompanyNum / total();
            return nf.format(result);
        }
    }

    public String getFourRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) fourRiskCompanyNum /total();
            return nf.format(result);
        }
    }


    public String getFiveRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) fiveRiskCompanyNum /total();
            return nf.format(result);
        }
    }

    public String getSixRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) sixRiskCompanyNum /total();
            return nf.format(result);
        }
    }

    public String getSevenRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) sevenRiskCompanyNum /total();
            return nf.format(result);
        }
    }

    public String getEightRiskCompanyNumRate() {
        if(!isNormal()){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            double result = (double) eightRiskCompanyNum /total();
            return nf.format(result);
        }
    }

    public boolean isNormal(){
        return total() > 0;
    }

    public Integer total(){
        return oneRiskCompanyNum + twoRiskCompanyNum+ threeRiskCompanyNum + fourRiskCompanyNum + fiveRiskCompanyNum + sixRiskCompanyNum + sevenRiskCompanyNum + eightRiskCompanyNum;
    }

}
