package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @ClassName AreaStaffingStatisticsVo
 * @Description 统计每个区域人员配置情况
 * @Author ChenLiang
 * @ModifyDate 2023/3/10 8:12
 */
@Data
@NoArgsConstructor
public class AreaStaffingStatisticsVo  implements Serializable {
    private static final long serialVersionUID = -1826442786732404753L;
    @ApiModelProperty("行政区划id")
    private Long areaId;
    @ApiModelProperty("行政区划名称")
    private String areaName;

    @ApiModelProperty("下级已配备协管员的区域数量")
    private Integer num;
    @ApiModelProperty("下级已配备属地乡镇辅助监督员的区域数量")
    private Integer num17;
    @ApiModelProperty("下级已配备医共体医务人员的区域数量")
    private Integer num18;
    @ApiModelProperty("下级区域总数量")
    private Integer totalNum;
    @ApiModelProperty("协管员数量")
    private Integer userNum;

    public AreaStaffingStatisticsVo(Long areaId, String areaName, Integer num, Integer totalNum, Integer userNum) {
        this.areaId = areaId;
        this.areaName = areaName;
        this.num = num;
        this.totalNum = totalNum;
        this.userNum = userNum;
    }
}
