package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Date;

/**
 * @ClassName AdminPatrolStatistics
 * @Description 协管工作档案统计
 * @Author ChenLiang
 * @ModifyDate 2023/3/9 8:39
 */
@Data
public class AdminPatrolStatisticsBackup20241231Vo implements Serializable {
    private static final long serialVersionUID = 5632455259415123490L;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("区域名称")
    private String areaName;
    @ApiModelProperty("区域等级")
    private Integer areaLevel;

    @ApiModelProperty("已整改数")
    private Integer rectifiedNum;
    @ApiModelProperty("风险数")
    private Integer riskNum;
    @ApiModelProperty("已化解风险数")
    private Integer resolvedNum;

    @ApiModelProperty("整改率分子）")
    private Integer rectificationRate1;
    @ApiModelProperty("整改率分母")
    private Integer rectificationRate2;
    @ApiModelProperty("整改率")
    private String rectificationRate;

    @ApiModelProperty("待整改风险数")
    private Integer toBeRectifiedNum;
    @ApiModelProperty("待验收风险数")
    private Integer toBeAccepted;

    @ApiModelProperty("超期未整改风险数（只来源关键因素画像）")
    private Integer overdueNotRectifiedNum;
    @ApiModelProperty("超期未验收数(只来源乡镇协管)")
    private Integer overdueNotAcceptedNum;

    @ApiModelProperty("红色预警风险数")
    private Integer redAlertNum;
    @ApiModelProperty("启动执法风险数")
    private Integer startEnforcementNum;

    @ApiModelProperty("下级区域数量")
    private Integer subAreaNum = 0;
    @ApiModelProperty("已分配协管员员区域")
    private Integer hasStaffAreaNum = 0;
    @ApiModelProperty("下级已配备属地乡镇辅助监督员的区域数量")
    private Integer hasStaffAreaNum17;
    @ApiModelProperty("下级已配备医共体医务人员的区域数量")
    private Integer hasStaffAreaNum18;
    @ApiModelProperty("管员员数量（目前区域为街道时，才查询这个数据）")
    private Integer staffNum;

    @ApiModelProperty("公司数量(不包括<3)")
    private Integer companyNum = 0;
    @ApiModelProperty("公司数量(正常营业)(不包括<3)")
    private Integer normalCompanyNum = 0;
    @ApiModelProperty("仅统计接害人数≥3人或无数据且正常营业的当年分类企")
    private Integer normalCompanyCurrNum = 0;
    @ApiModelProperty("公司数量(暂停营业)(不包括<3)")
    private Integer suspensionCompanyNum = 0;

    @ApiModelProperty("已经巡查公司数量(不包括<3)")
    private Integer patroledCompanyNum = 0;
    @ApiModelProperty("已经巡查公司数量(正常营业)(不包括<3)")
    private Integer patroledNormalCompanyNum = 0;
    @ApiModelProperty("已经巡查公司数量(暂停营业)(不包括<3)")
    private Integer patroledSuspensionCompanyNum = 0;

    @ApiModelProperty("所有地址未精确到街道的公司数量(包括<3)")
    private Integer allLT4AreaCompanyNum = 0;

    @ApiModelProperty("所有公司数量(包括<3)")
    private Integer allCompanyNum = 0;
    @ApiModelProperty("所有公司数量(正常营业)(包括<3)")
    private Integer allNormalCompanyNum = 0;
    @ApiModelProperty("所有公司数量(暂停营业)(包括<3)")
    private Integer allSuspensionCompanyNum = 0;

    @ApiModelProperty("所有需巡查公司数量(不包括<3)")
    private Integer irCompanyNum = 0;
    @ApiModelProperty("所有需巡查公司数量(正常营业)(不包括<3)")
    private Integer irNormalCompanyNum = 0;
    @ApiModelProperty("所有需巡查公司数量(暂停营业)(不包括<3)")
    private Integer irSuspensionCompanyNum = 0;

    @ApiModelProperty("所有需巡查公司中已经巡查的数量(不包括<3)")
    private Integer irPatroledCompanyNum = 0;
    @ApiModelProperty("所有需巡查公司中已经巡查的数量(正常营业)(不包括<3)")
    private Integer irPatroledNormalCompanyNum = 0;
    @ApiModelProperty("所有需巡查公司中已经巡查的数量(暂停营业)(不包括<3)")
    private Integer irPatroledSuspensionCompanyNum = 0;

    @ApiModelProperty("自查率(不包括<3)")
    private String selfInspectionRate;

    @ApiModelProperty("巡查覆盖率(不包括<3)")
    private String patroaledCompanyRate;

    @ApiModelProperty("巡查覆盖率(正常营业)(不包括<3)")
    private String normalPatroaledCompanyRate;

    @ApiModelProperty("巡查覆盖率(暂停营业)(不包括<3)")
    private String suspensionPatroaledCompanyRate;

    @ApiModelProperty("最近一次巡查时间")
    private Date lastPatrolTime;
    @ApiModelProperty("最近一次更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty(value = "企业等级（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    public String getRectificationRate(){
        if(rectificationRate1 == null || rectificationRate2 == null ||  rectificationRate2 == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) rectificationRate1 /rectificationRate2 );
        }
    }

//    public Double comparatorRuleForRectificationRate(){
//        if(rectificationRate1 == null || rectificationRate2 == null ||  rectificationRate2 == 0){
//            return -1d;
//        }else {
//            NumberFormat nf = NumberFormat.getPercentInstance();
//            nf.setMinimumFractionDigits(2);
//            return (double) rectificationRate1 /rectificationRate2;
//        }
//    }

    public String getPatroaledCompanyRate(){
        if(patroledCompanyNum == null || companyNum == null || companyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledCompanyNum / companyNum);
        }
    }
    public String getNormalPatroaledCompanyRate(){
        if(patroledNormalCompanyNum == null || normalCompanyNum == null || normalCompanyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledNormalCompanyNum / normalCompanyNum);
        }
    }
    public String getSuspensionPatroaledCompanyRate(){
        if(patroledSuspensionCompanyNum == null || suspensionCompanyNum == null || suspensionCompanyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledSuspensionCompanyNum / suspensionCompanyNum);
        }
    }

}
