package cn.smarthse.township.manage.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Date;

/**
 * @ClassName AdminPatrolStatistics
 * @Description 协管工作档案统计(年度指标)
 * @Author ChenLiang
 * @ModifyDate 2023/3/9 8:39
 */
@Data
public class AdminPatrolStatisticsAnnualIndicatorsVo implements Serializable {
    private static final long serialVersionUID = 5632455259415123490L;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("区域名称")
    private String areaName;











    @ApiModelProperty("公司数量")
    private Integer companyNum = 0;
    @ApiModelProperty("公司数量(正常营业)")
    private Integer normalCompanyNum = 0;
    @ApiModelProperty("仅统计接害人数≥3人或无数据且正常营业的当年分类企")
    private Integer normalCompanyCurrNum = 0;
    @ApiModelProperty("公司数量(暂停营业)")
    private Integer suspensionCompanyNum = 0;

    @ApiModelProperty("已经巡查公司数量")
    private Integer patroledCompanyNum = 0;
    @ApiModelProperty("已经巡查公司数量(正常营业)")
    private Integer patroledNormalCompanyNum = 0;
    @ApiModelProperty("已经巡查公司数量(暂停营业)")
    private Integer patroledSuspensionCompanyNum = 0;


    @ApiModelProperty("所有公司数量")
    private Integer allCompanyNum = 0;
    @ApiModelProperty("所有公司数量(正常营业)")
    private Integer allNormalCompanyNum = 0;
    @ApiModelProperty("所有公司数量(暂停营业)")
    private Integer allSuspensionCompanyNum = 0;


    @ApiModelProperty("巡查覆盖率")
    private String patroaledCompanyRate;

    @ApiModelProperty("巡查覆盖率(正常营业)")
    private String normalPatroaledCompanyRate;

    @ApiModelProperty("巡查覆盖率(暂停营业)")
    private String suspensionPatroaledCompanyRate;







    public String getPatroaledCompanyRate(){
        if(patroledCompanyNum == null || companyNum == null || companyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledCompanyNum / companyNum);
        }
    }
    public String getNormalPatroaledCompanyRate(){
        if(patroledNormalCompanyNum == null || normalCompanyNum == null || normalCompanyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledNormalCompanyNum / normalCompanyNum);
        }
    }
    public String getSuspensionPatroaledCompanyRate(){
        if(patroledSuspensionCompanyNum == null || suspensionCompanyNum == null || suspensionCompanyNum == 0){
            return "-";
        }else {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return nf.format((double) patroledSuspensionCompanyNum / suspensionCompanyNum);
        }
    }

}
