package cn.smarthse.township.manage.vo.admin;

import cn.hutool.core.util.NumberUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

import java.text.DecimalFormat;
import java.util.Date;


/**
 *
 * 移动端：首页-统计信息
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/3/8 11:05
 */
@Data
public class AdminHomeData implements Serializable {

    private static final long serialVersionUID = -3108145319675065718L;

    @ApiModelProperty("用户姓名")
    private String name;

    @ApiModelProperty("用户地址")
    private String address;

    @ApiModelProperty("分类自查率")
    private String selfCheckPercent;

    @ApiModelProperty(value = "巡查整改率-分子(已验收风险数）", notes = "status=3")
    private Integer acceptRiskNum = 0;

    @ApiModelProperty("巡查整改率 = 已验收风险数 / (已经发现的风险数 + 未巡查企业数 * 4))即：acceptRiskNum / [reformRiskNum + (companyNum - patrolCompanyNum) * 4]")
    private String acceptRiskPercent;

    @ApiModelProperty("最近更新时间")
    private Date lastUpdateDate;

    @ApiModelProperty("巡查企业数")
    private Integer patrolCompanyNum = 0;

    @ApiModelProperty("未巡查企业数")
    private Integer unPatrolCompanyNum = 0;

    @ApiModelProperty("未巡查企业数（营业状态: 1-正常）")
    private Integer unPatrolCompanyNum1 = 0;

    @ApiModelProperty("未巡查企业数（营业状态: 2-暂停营业）")
    private Integer unPatrolCompanyNum2 = 0;

    @ApiModelProperty("辖区内企业数")
    private Integer companyNum = 0;

    @ApiModelProperty("辖区内企业数（营业状态: 1-正常）")
    private Integer companyNum1 = 0;

    @ApiModelProperty("辖区内企业数（营业状态: 2-暂停营业）")
    private Integer companyNum2 = 0;

    @ApiModelProperty("待验收风险清单数（status=2）")
    private Integer unacceptRiskNum = 0;

    @ApiModelProperty("待整改风险清单数（status=1）")
    private Integer unReformRiskNum = 0;

    @ApiModelProperty("辖区内总风险清单数")
    private Integer reformRiskNum = 0;

    public void setAcceptRiskPercent(Integer acceptRiskNum, Integer reformRiskNum, Integer unPatrolCompanyNum) {

        //巡查整改率= 已验收风险数 / 已经发现的风险数 + 未巡查企业数 * 4
        if (reformRiskNum == null || reformRiskNum == 0) {
            return;
        }
        unPatrolCompanyNum = (unPatrolCompanyNum == null ? 0 : unPatrolCompanyNum);

        DecimalFormat format = new DecimalFormat("0.0%");
        Integer sum = reformRiskNum + unPatrolCompanyNum * 4;
        this.acceptRiskPercent = format.format(NumberUtil.div(acceptRiskNum, sum, 3));
    }
}
