package cn.smarthse.township.manage.provider.company;

import cn.smarthse.township.manage.vo.company.CompanyPatrolDetailDataVo;
import cn.smarthse.township.manage.vo.company.CompanyPatrolIndexDataVo;
import cn.smarthse.township.manage.vo.company.CompanyRiskNotificationDataVo;
import cn.smarthse.township.manage.vo.company.CompanyTownShipIndexVo;

import java.util.List;
import java.util.Map;

/**
 * 提供给企业端dubbo服务
 *
 * @author ShenZQ
 * @since 2023/3/9 13:21
 */
public interface IPatrolToCompanyProviderService {

    /**
     * 企业端——巡查列表数据
     *
     * @param cid
     * @return {@link Map<Integer,List< CompanyPatrolIndexDataVo >>}
     * @author ShenZQ
     * @since 2023/3/9 13:30
     */
    Map<Integer, List<CompanyPatrolIndexDataVo>> getCompanyPatrolIndexData(Long cid);

    /**
     * 企业端——巡查列表数据
     *
     * @param cid
     * @return {@link Map<Integer,List< CompanyPatrolIndexDataVo >>}
     * @author ShenZQ
     * @since 2023/3/9 13:30
     */
    Map<Integer, List<CompanyPatrolIndexDataVo>> getCompanyPatrolAreaIndexData(Long cid, Long areaId, Integer areaLevel);

    /**
     * 企业端——巡查详情
     *
     * @param patrolId
     * @return {@link CompanyPatrolDetailDataVo}
     * @author ShenZQ
     * @since 2023/3/9 16:27
     */
    CompanyPatrolDetailDataVo getCompanyPatrolIDetailData(Long patrolId);

    /**
     * 风险告知
     *
     * @param patrolId
     * @return {@link CompanyRiskNotificationDataVo}
     * @author ShenZQ
     * @since 2023/3/10 9:45
     */
    CompanyRiskNotificationDataVo getCompanyRiskNotificationData(Long patrolId);

    /**
     * 企业端可视化乡镇协管员数据
     *
     * @param cid
     * @return {@link CompanyTownShipIndexVo}
     * @author ShenZQ
     * @since 2023/4/26 13:21
     */
    @Deprecated
    CompanyTownShipIndexVo getCompanyTownShipIndexData(Long cid);

    /**
     * @description: 企业端可视化乡镇协管员数据（优化）
     * 参考：cn.smarthse.township.manage.provider.company.PatrolToCompanyProviderServiceImpl#getCompanyTownShipIndexData，进行的优化实现。
     * @date: 2025-01-2 17:33
     * @param: 传参说明：
     * 		cid -> 企业id
     * @return: {@link CompanyTownShipIndexVo} 助企协管可视化信息
     * @author: DengJia 18402894534@163.com
     */
    CompanyTownShipIndexVo getTownshipAssistanceData(Long cid);

}
