package cn.smarthse.township.manage.provider.admin;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.township.manage.param.AdminPatrolStatisticsAnnualIndicatorsParam;
import cn.smarthse.township.manage.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.param.StreetCompanyStatisticsParam;
import cn.smarthse.township.manage.param.WorkFileHistoryPageParam;
import cn.smarthse.township.manage.vo.admin.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface IPatrolStatisticsServiceProvider {
    /**
     * 协管工作档案统计
     * @param param
     * @return {@link JqGridData < AdminPatrolStatisticsVo>}
     * @author chenliang
     * @date 2023/3/9 9:18
     */
    JqGridData<AdminPatrolStatisticsVo> getPatrolStatisticsList(AdminPatrolStatisticsParam param);

    /**
     * 街道分页统计
     * @param param
     * @return
     */
    JqGridData<AdminPatrolStatisticsVo> getStreetAreaPatrolStatisticsList(AdminPatrolStatisticsParam param);
    /**
     * 街道分页统计(排除空数据)
     * @Author ChenLiang
     * @Date 20:24 2024/8/2
     * @param param
     * @return JqGridData<AdminPatrolStatisticsVo>
     */
    JqGridData<AdminPatrolStatisticsVo> getStreetAreaPatrolStatisticsListExNull(AdminPatrolStatisticsParam param);

    /**
     * 协管工作档案统计-总计
     * @param param
     * @return {@link AdminPatrolStatisticsVo}
     * @author chenliang
     * @date 2023/3/10 10:21
     */
    AdminPatrolStatisticsVo getPatrolStatisticsTotal(AdminPatrolStatisticsParam param);

    /**
     * 街道巡查公司数据统计参数总计
     * @param param
     * @return {@link StreetCompanyStatisticsTotalVo}
     * @author chenliang
     * @date 2023/3/10 15:32
     */
    StreetCompanyStatisticsTotalVo getStreetCompanyStatisticsTotal(StreetCompanyStatisticsParam param);

    /**
     * 街道巡查公司数据统计
     * @param param
     * @return {@link JqGridData< StreetCompanyStatisticslVo>}
     * @author chenliang
     * @date 2023/3/15 9:33
     */
    JqGridData<StreetCompanyStatisticslVo> getStreetCompanyStatisticsList(StreetCompanyStatisticsParam param);

    /**
     * 查询街道协管数量
     * @param areaId
     * @return {@link Integer}
     * @author chenliang
     * @date 2023/3/15 11:16
     */
    AdminPatrolStatisticsVo getStreetStaffNum(Long areaId);

    /**
     * @description: 可视化-行政区划巡查化解率情况
     * @author: chenliang
     * @date: 2023/10/10 9:15
     * @param param
     * @return: {@link List< AdminPatrolStatisticsVo>}
     */
    List<AdminPatrolStatisticsVo> getRectificationForVisualization(AdminPatrolStatisticsParam param);

    /**
     * 可视化-行政区划巡查覆盖率
     * @Author ChenLiang
     * @Date 15:12 2024/7/13
     * @param param
     * @return List<AdminPatrolStatisticsVo>
     */
    List<AdminPatrolStatisticsVo> getPatrolRateForVisualization(AdminPatrolStatisticsParam param);

    List<AdminPatrolStatisticsAnnualIndicatorsVo> getPatrolRateForAnnualIndicators(AdminPatrolStatisticsAnnualIndicatorsParam param);

    /**
     * @description: 可视化-企业风险数量分布情况
     * @author: chenliang
     * @date: 2023/10/10 15:07
     * @param param
     * @return: {@link EnterpriseRiskDistributionVo}
     */
    EnterpriseRiskDistributionVo getEnterpriseRiskDistribution(AdminPatrolStatisticsParam param);

    /**
     * 查询企业最近一次的巡查时间
     * @param cid 企业id
     * @return {@link Date}
     * @author chuhy
     * @date 2023/3/17
     */
    String getLastPatrolDateByCid(Long cid);

    /**
     * 方法描述:  是否完成本年度巡查工作
     *
     * @param   cid 企业id
     * @return  Boolean
     * @author  wuxq
     * @date    2023/3/21
     */
    Boolean isFinishedCurrYearPatrol(Long cid);

    /**
     * 统计 当前巡查过的单位数
     * @param areaId 行政区划 12位
     * @param year 年份
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/3/8 14:37
     */
    int getUnPatrolCompanyNum(Long areaId, Integer year);

    /**
     *
     * 统计当前区域下 未巡查过的单位数
     * @param areaId 行政区划 12位
     * @param year 年份
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/3/8 14:37
     */
    Map getUnPatrolCompanyNumByAreaPid(Long areaId, Integer areaLevel);
    /**
     * 监管：首页 乡镇协管统计
     * @param areaId 行政区划
     * @param areaLevel 行政区划level
     * @param isCurrent 是否尽显示本级数据
     * @param year 年份
     * @return {@link HomeSupervisionTownshipVo}
     * @author liaoly(廖凌云)
     * @date 2023/10/9 15:31
     */
    HomeSupervisionTownshipVo getHomeTownship(Long areaId, Integer areaLevel, Boolean isCurrent, int year);

    /**
     * 方法描述:  查看某区域的下级区域已配备协管员的街道数量
     *
     * @param   areaId 区域id
     * @param   areaLevel 区域等级
     * @return  List<AreaStaffingStatisticsVo>
     * @author  wuxq
     * @date    2023/10/9
     */
    List<AreaStaffingStatisticsVo> getAreaStaffingData(Long areaId, Integer areaLevel, Byte system);
    /**
     *
     * 统计 当前未巡查过的单位数
     * @param areaId 行政区划 12位
     * @param year 年份
     * @param belongType 企业直属类型
     * @return {@link AdminHomeData} companyNum、companyNum1、companyNum2
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/3/8 14:37
     */
    AdminHomeData getUnPatrolCompanyNum2(Long areaId, int year, Integer belongType);

    AdminPatrolStatisticsVo getCompanyNumDataForHome(Long areaId, Integer areaLevel, Boolean isCurrent, Integer isFcyth);

    void addWorkFile();

    void addWorkFileForProvince();

    void addWorkFileForCity();

    void addWorkFileForArea();

    void addWorkFileForStreet();

    WorkFileHistoryVo getTotal(WorkFileHistoryPageParam param);

    List<WorkFileHistoryVo> getList(WorkFileHistoryPageParam param);

    /**
     * 方法描述:  查询巡查覆盖率情况
     *
     * @param   param
     * @return  AdminPatrolStatisticsVo
     * @author  wuxq
     * @date    2024/2/28
     */
    AdminPatrolStatisticsVo getPatrolCoverData(AdminPatrolStatisticsParam param);

    /**
     * 方法描述:  查询 所有街道巡查覆盖率情况
     *
     * @param   param
     * @return  AdminPatrolStatisticsVo
     * @author  wuxq
     * @date    2024/2/28
     */
    List<AdminPatrolStatisticsVo> getStreetsPatrolCoverData(AdminPatrolStatisticsParam param);

    WorkFileHistoryStorageProgressVo getWorkFileStorageProgress();

    void delProgress();

    /**
     * 首页可视化-统计统计行政区划下未具体到街道的企业数(与getPatrolStatisticsTotal中的数量保持一致)
     * @param
     * @return {@link AdminPatrolStatisticsVo}
     * @author chuhy
     * @date 2024/3/27 10:50
     */
    AdminPatrolStatisticsVo countCompanyNumForHome(Long areaId, Integer areaLevel, Integer belongType, Integer isFcyth);


    /**
     * 首页可视化-计算巡查覆盖率所需的相关数据
     * @param areaId
     * @param level
     * @return {@link List< HomeSupervisionPatrolStatisticsData>}
     * @author chuhy
     * @date 2024/4/10 15:07
     */
    List<HomeSupervisionPatrolStatisticsData> listStreetCompanyPatrolStatisticsForHome(Long areaId, Integer level, Integer belongType, Integer isFcyth);

    /**
     * 方法描述:  自查率（暂时放着，别用）
     *
     * @return  Map<Long,String>
     * @author  wuxq
     * @since    2024/8/1
     */
    List<SelfCommitRateAreaModel> collectGradeCaseSelfInfoByParentId(Long parentId, Integer areaLevel, Integer includeBelongType, Boolean cityLevel, Integer showType, Byte systemDeploymentSource,Integer isFcyth);

}
