package cn.smarthse.township.manage.provider.admin;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.model.ReformRateStatisticVo;
import cn.smarthse.township.manage.param.AdminPatrolStatisticsBackup20241231Param;
import cn.smarthse.township.manage.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.param.RiskSolveRateSearchParam;
import cn.smarthse.township.manage.vo.admin.AdminPatrolStatisticsBackup20241231Vo;
import cn.smarthse.township.manage.vo.admin.AdminPatrolStatisticsVo;
import cn.smarthse.township.manage.vo.admin.SelfCommitRateAreaModel;

import java.util.List;

public interface IPatrolStatisticsServiceBackup2024Provider {
    /**
     * 协管工作档案统计
     *
     * @param param
     * @return {@link JqGridData < AdminPatrolStatisticsBackup20241231Vo>}
     * @author chenliang
     * @date 2023/3/9 9:18
     */
    JqGridData<AdminPatrolStatisticsBackup20241231Vo> getPatrolStatisticsList(AdminPatrolStatisticsBackup20241231Param param);

    /**
     * 街道分页统计
     *
     * @param param
     * @return
     */
    JqGridData<AdminPatrolStatisticsBackup20241231Vo> getStreetAreaPatrolStatisticsList(AdminPatrolStatisticsBackup20241231Param param);

    /**
     * 街道分页统计(排除空数据)
     *
     * @param param
     * @return JqGridData<AdminPatrolStatisticsBackup20241231Vo>
     * @Author ChenLiang
     * @Date 20:24 2024/8/2
     */
    JqGridData<AdminPatrolStatisticsBackup20241231Vo> getStreetAreaPatrolStatisticsListExNull(AdminPatrolStatisticsBackup20241231Param param);

    /**
     * 协管工作档案统计-总计
     *
     * @param param
     * @return {@link AdminPatrolStatisticsBackup20241231Vo}
     * @author chenliang
     * @date 2023/3/10 10:21
     */
    AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotal(AdminPatrolStatisticsBackup20241231Param param);

    AreaModel getAreaById(Long areaId);

    // =====================================================================================================================================
    AdminPatrolStatisticsBackup20241231Vo getPatrolCoverData(AdminPatrolStatisticsBackup20241231Param param);

    List<AdminPatrolStatisticsVo> getStreetsPatrolCoverData(AdminPatrolStatisticsParam param);

    List<SelfCommitRateAreaModel> collectGradeCaseSelfInfoByParentId(Long parentId, Integer areaLevel, Integer includeBelongType, Boolean cityLevel, Integer showType, Byte systemDeploymentSource, Integer isFcyth);

    String collectGradeCaseSelfInfoByAreaId(Long areaId, Integer year, Boolean onlyThislevel, Byte systemDeploymentSource, Integer isFcyth);

    ReformRateStatisticVo reformRateTotalData(RiskSolveRateSearchParam param);

}
