package cn.smarthse.township.manage.param;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.smarthse.exception.ServiceException;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 乡镇协管工作档案历史记录查询
 */
@Data
public class WorkFileHistoryPageParam implements Serializable {
    private static final long serialVersionUID = -136931956046466120L;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("区域等级")
    private Integer areaLevel;

    @ApiModelProperty("批次编码")
    private String batchCode;

    @ApiModelProperty("卡片类型 -1 全部，0 非直属，2市直属")
    private Integer belongType;

//    @ApiModelProperty("卡片类型 -1 全部，0 非直属，2市直属")
//    private List<Integer> belongTypeList;

    @ApiModelProperty("是否包含市直属卡片（0否 1市）")
    private Integer includeDirectCard;

}
