package cn.smarthse.township.manage.param;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @ClassName StreetCompanyStatisticsParam
 * @Description 街道巡查公司数据统计参数
 * @Author ChenLiang
 * @ModifyDate 2023/3/10 15:29
 */
@Data
public class StreetCompanyStatisticsParam extends JqGridParam implements Serializable {

    @ApiModelProperty("换成key")
    private String cacheKey;

    @ApiModelProperty("不缓存条件")
    private String nonCacheCondition;

    @ApiModelProperty("系统来源")
    private Byte systemDeploymentSource;

    @ApiModelProperty("是否粉尘重点企业")
    private Integer isFcyth;

    @ApiModelProperty("接害人数，逗号隔开（0：小于3; 1：大于等于3; 2：无数据; null: 大于等于3或者无数据 ）")
    private String victimsNum;

    @ApiModelProperty("营业状态(0 已关闭, 1 正常营业, 2 暂停营业)")
    private String businessState;

    @ApiModelProperty("区域id")
    @NotNull
    private Long areaId;

    @ApiModelProperty("区域等级")
    private Byte level;

    @ApiModelProperty("年份")
    @NotNull
    private Integer year;

    @ApiModelProperty("1 甲类, 2 乙类, 3 丙类")
    private Integer riskType;

    @ApiModelProperty("是否存在超期未验收(0 否 1 是)（废弃）")
    private Integer hasOverdueNotAccepted;

    @ApiModelProperty("是否存在超期未整改(0 否 1 是)（废弃）")
    private Integer hasOverdueNotRectified;

    @ApiModelProperty("是否存在待整改(0 否 1 是)")
    private Integer hasToBeRectified;

    @ApiModelProperty("是否存在待验收(0 否 1 是)")
    private Integer hasToBeAccepted;

    @ApiModelProperty("是否存特殊条件(1 存在红色预警未化解企业 2 存在启动执法未化解企)")
    private Integer specialType;

    @ApiModelProperty("当年是否巡逻(0 否 1 是)")
    private Integer hasCurrYearPatrol;

    @ApiModelProperty("搜索关键词")
    private String keyWord;

    @ApiModelProperty("直属企业类型（0-非直属，1-省直属，2-市属）")
    private Integer belongType;

    @ApiModelProperty("风险化解情况（0-全部已化解；1~8：一~八项风险以化解）")
    private Integer noCompletedNum;

    public String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.areaId).append(this.year).append(this.belongType)
                .append(this.businessState).append(this.victimsNum)
                .append(this.systemDeploymentSource).append(this.isFcyth)
                .append(this.riskType).append(this.specialType).append(this.hasToBeAccepted)
                .append(this.hasToBeRectified).append(this.getHasCurrYearPatrol()).append(this.getNoCompletedNum())
        ;
        return sb.toString();
    }

    public Boolean getNonCacheCondition() {
        return (this.systemDeploymentSource != null && this.systemDeploymentSource == 1) || this.level > 2 ;
    }

}
