package cn.smarthse.township.manage.param;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 风险化解率统计 搜索参数对象
 *
 * @author wuxq
 * @since 2023年3月9日-上午9:39:16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RiskSolveRateSearchParam extends JqGridParam {

    /**
     * 区域id
     */
    private Long areaId;
    /**
     * 区域pid
     */
    private Long areaPid;
    /**
     * 区域等级
     */
    private Integer areaLevel;

    /**
     * 区域id
     */
    private Long searchAreaId;
    private Integer searchAreaLevel;

    /**
     * 查询标识
     */
    private Boolean selectFlag = false;

    /**
     * 查询标识
     */
    private Boolean cityLevel;

    /**
     * 导出标识
     */
    private Boolean isExport = false;

    /**
     *
     */
    private String batchNo;

    /**
     * 排序类型：1-巡查化解率；2-自查报提交率；3-巡查覆盖率
     */
    private Integer sortType = 1;

    /**
     * 系统部署来源SystemDeploymentSourceEnum
     */
    private Byte systemDeploymentSource;


    /**
     * 是否是否粉尘重点企业
     */
    private Integer isFcyth;
    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    private Integer isFcImportanceCompany;

}
