package cn.smarthse.township.manage.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Classname PatrolInfoCurrencyStatisticsParam
 * @Description 巡查统计通用参数
 * @Date 2023/7/31 16:42
 * @Author chenliang
 */
@Data
@Accessors(chain = true)
public class PatrolInfoCurrencyStatisticsParam implements Serializable {
    private static final long serialVersionUID = -2168003951196329388L;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("区域等级")
    private Integer areaLevel;
    @ApiModelProperty("年份")
    private Integer year;
    @ApiModelProperty("直属企业类型（0-非直属，1-省直属，2-市属）")
    private Integer belongType;
    @ApiModelProperty("街道区域id")
    private List<Long> streetIdList;
    @ApiModelProperty("公司id")
    private List<Long> cidList;
}
