package cn.smarthse.township.manage.param;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.smarthse.exception.ServiceException;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @ClassName AdminPatrolStatisticsBackup20241231Param
 * @Description 协管工作档案统计
 * @Author ChenLiang
 * @ModifyDate 2023/3/9 8:59
 */
@Data
public class AdminPatrolStatisticsBackup20241231Param extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -136931956046466120L;

    @ApiModelProperty("缓存成key")
    private String cacheKey;
    @ApiModelProperty("不缓存条件")
    private String nonCacheCondition;

    @ApiModelProperty("系统来源")
    private Byte systemDeploymentSource;

    @ApiModelProperty("是否粉尘重点企业")
    private Integer isFcyth;

    @ApiModelProperty("接害人数，逗号隔开（0：小于3; 1：大于等于3; 2：无数据;null: 大于等于3或者无数据 ）")
    private String victimsNum;

    @ApiModelProperty("营业状态（1-正常，2-暂停营业，0-关闭）")
    private String businessState;

    @ApiModelProperty("区域id")
    @NotNull
    private Long areaId;

    @ApiModelProperty(value = "等级筛选条件（null全部 true仅显示本级 false仅显示非本级）",required = false)
    private Boolean companyLevelType;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer includeBelongType;

    @ApiModelProperty(value = "列表类型(null：父区域子级区域列表； 2：市本级的街道列表)")
    private Integer areaListType;

    @ApiModelProperty("区域等级")
    private Integer areaLevel;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("0否 1是")
    private Integer isCached;

    @ApiModelProperty("区域限制列表")
    private List<Long> areaIdList;

    @ApiModelProperty(value = "是否显示所有区县")
    private Boolean allAreas = false;

    /**
     * 全部街道
     */
    private Boolean allStreets = false;

    @ApiModelProperty("排序")
    private Integer sortType;

    /**
     * 导出标识
     */
    private Boolean isExport = false;

    public Integer parsingArgumentsForOnlyCurrentLevel(Integer selectedAreaLevel, Boolean onlyCurrentLevel) {
        //仅显示本级条件处理
        Integer selectedLevelType = selectedAreaLevel <= 2 ? 1 : 2;//1省市 2区县
        Integer belongType = null;
        if(onlyCurrentLevel == null){
            belongType = null;
        }else if(onlyCurrentLevel == true) {
            belongType = selectedLevelType == 1 ? 2 : 0;
        }else if(onlyCurrentLevel == false) {
            belongType = selectedLevelType == 1 ? 0 : 2;
        }else {
            throw new ServiceException("本级参数错误");
        }
        return belongType;
    }

    public String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append("20241231").append(this.areaId).append(this.year).append(this.belongType)
                .append(this.businessState).append(this.victimsNum).append(this.includeBelongType)
                .append(this.systemDeploymentSource).append(this.isFcyth);
        return sb.toString();
    }

    public Boolean getNonCacheCondition() {
        return (this.isCached != null && this.isCached == 0) || (this.systemDeploymentSource != null && this.systemDeploymentSource == 1);
    }
}
