package cn.smarthse.township.manage.param;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.smarthse.exception.ServiceException;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @ClassName AdminPatrolStatisticsParam
 * @Description 协管工作档案统计(年度指标模块用)
 * @Author ChenLiang
 */
@Data
public class AdminPatrolStatisticsAnnualIndicatorsParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -136931956046466120L;

    @ApiModelProperty("查询区域范围：2所有市 3所有区")
    private Integer areaScope;

    @ApiModelProperty("系统来源SystemDeploymentSourceEnum")
    private Byte systemDeploymentSource;

    @ApiModelProperty("是否粉尘重点企业")
    private Integer isFcyth;

    @ApiModelProperty("接害人数，逗号隔开（0：小于3; 1：大于等于3; 2：无数据;null: 大于等于3或者无数据 ）")
    private String victimsNum;

    @ApiModelProperty("营业状态，逗号隔开（1-正常，2-暂停营业，0-关闭）")
    private String businessState;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）")
    private Integer belongType;

    @ApiModelProperty("年份")
    private Integer year;



}
