package cn.smarthse.township.manage.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;


/**
 * <p>乡镇协管 巡查化解率 统计 VO对象</p>
 *
 * <p>
 * (正常营业 + 接害人数≥3人或无数据 + 已化解全部8个风险或无风险 + 有2024年巡查记录)的企业
 * ——————————————————————————————————————————————————————————————————————————
 * (分类对象 + 正常营业 + 接害人数 ≥ 3人或无数据)的企业
 * </p>
 *
 * @author wuxq
 * @since 2023年3月9日-上午9:39:16
 */
@Data
public class ReformRateStatisticVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 区域id
     */
    private Long areaId;
    private Long areaId1;
    private Long areaId2;
    private Long areaId3;
    private Long areaId4;
    /**
     * 区域名称
     */
    private String areaName;
    /**
     * 区域名称
     */
    private String areaLevel;

    private Boolean cityLevel = false;

    /**
     * 画像化解风险数
     */
    private int huaxiangHasReformedNum;
    /**
     * 画像风险数
     */
    private int huaxiangRiskNum;

    /**
     * 市本级统计
     */
    private int cityHuaxiangHasReformedNum;
    private int cityHuaxiangRiskNum;

    /**
     * 本年度化解率
     */
    private String currentHasReformedRate = "-";
    private Double currentHasReformedRateV;

    /**
     * 自查表提交率
     */
    private String selfCommitRate = "-";
    private Double selfCommitRateV;

    /**
     * 需巡查正常营业企业数（接害人数≥3人或无数据+分类对象+正常营业）
     */
    private int needPatrolBusinessCNum;
    /**
     * 当年分类企业数（接害人数≥3人或无数据+当年分类对象+正常营业）
     */
    private int needPatrolCurrBusinessCNum;

    /**
     * 已巡查企业数
     */
    private int patrolledCNum;

    /**
     * 巡查覆盖率
     */
    private String patrolCoverRate = "-";
    private Double patrolCoverRateV;

    public String getCurrentHasReformedRate() {
        BigDecimal result = this.rateProcessing(this.huaxiangHasReformedNum, huaxiangRiskNum);
        return result == null ? "-" : result + "%";
    }

    public BigDecimal getHasReformedRate() {
        return this.rateProcessing(this.huaxiangHasReformedNum, huaxiangRiskNum);
    }

    public BigDecimal rateProcessing(int a, int b) {

        boolean aFlag = (a == 0);
        boolean bFlag = (b == 0);

        if (aFlag && bFlag) return null;
        if (aFlag) return new BigDecimal("0.00");
        if (bFlag) return null;

        BigDecimal aDecimal = new BigDecimal(a);
        BigDecimal bDecimal = new BigDecimal(b);
        return aDecimal.multiply(new BigDecimal(100)).divide(bDecimal, 2, RoundingMode.HALF_UP);
    }

    public Double getCurrentHasReformedRateV() {
        if (!Objects.equals(this.getCurrentHasReformedRate(), "-") && this.getCurrentHasReformedRate().contains("%")) {
            return Double.parseDouble(this.getCurrentHasReformedRate().substring(0, this.getCurrentHasReformedRate().length() - 1));
        }
        return Double.parseDouble("0.00");
    }

    public Double getSelfCommitRateV() {
        if (!Objects.equals(this.getSelfCommitRate(), "-") && this.getSelfCommitRate().contains("%")) {
            return Double.parseDouble(this.getSelfCommitRate().substring(0, this.getSelfCommitRate().length() - 1));
        }
        return Double.parseDouble("0.00");
    }

    public Double getPatrolCoverRateV() {
        if (!Objects.equals(this.getPatrolCoverRate(), "-") && this.getPatrolCoverRate().contains("%")) {
            return Double.parseDouble(this.getPatrolCoverRate().substring(0, this.getPatrolCoverRate().length() - 1));
        }
        return Double.parseDouble("0.00");
    }
}
