package cn.smarthse.township.manage.enums.manage;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)
 *
 * @author chuhy
 * @date 2023/3/10 16:10
 */
@AllArgsConstructor
@Getter
public enum PatrolStatusEnums {

    /**
     * 0-未开始
     */
    NOT_STARTED(0, "未开始"),
    /**
     * 1-进行中
     */
    PATROLLING(1, "进行中"),
    /**
     * 2-已完成
     */
    DONE(2, "已完成"),
    /**
     * 3-已终止
     */
    END(3, "已终止"),
    ;

    private final Integer code;

    private final String name;

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (PatrolStatusEnums c : PatrolStatusEnums.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }

}
