/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.task;

import cn.smarthse.tt.constants.SpecialistConstants;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferQuestionTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferQuestionTask.class);
    @Autowired
    @Lazy
    private ISpecialistQuestionRecordService questionRecordService;
    @Autowired
    @Lazy
    private ISpecialistQuickQuestionService questionService;

    @XxlJob(value="transferQuestionTask-transferTask")
    @Transactional(propagation=Propagation.REQUIRED)
    public void handleOvertimeTransfer() {
        List<SpecialistQuestionRecord> allLatestRecords = this.questionRecordService.getAllLatestRecords();
        if (CollectionUtils.isNotEmpty(allLatestRecords)) {
            for (SpecialistQuestionRecord record : allLatestRecords) {
                if (record.getIsHistory().booleanValue() || !Objects.equals(SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey(), record.getQuestionStatus()) || record.getReceiveSpecialistId() == null || record.getReceiveSpecialistId().equals(SpecialistConstants.SYS_SPECIALIST_ID) || record.getNoResponseTime() == null || record.getNoResponseTime().getTime() > System.currentTimeMillis()) continue;
                SpecialistQuestionRecord newRecord = new SpecialistQuestionRecord();
                newRecord.setQuestionId(record.getQuestionId());
                newRecord.setTransferType(Integer.valueOf(2));
                newRecord.setReasonType(Integer.valueOf(3));
                newRecord.setSpecialistFieldType(record.getSpecialistFieldType());
                newRecord.setTransferSpecialistId(record.getReceiveSpecialistId());
                this.questionRecordService.transferQuestion(newRecord, null);
                Long expertId = this.questionService.transferAndMatchExpertId(newRecord);
                this.questionRecordService.setReceiveSpecialist(record.getQuestionId(), null, expertId, null);
            }
        }
    }
}

