/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.task;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.tt.entity.SpecialistAnswerCount;
import cn.smarthse.tt.service.tt.ISpecialistAnswerCountService;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistQuestionCount;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SpecialistCountTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecialistCountTask.class);
    private final ISpecialistInfoService specialistInfoService;
    private final ISpecialistAnswerCountService answerCountService;
    private final ISpecialistQuestionRecordService questionRecordService;
    private final ISpecialistQuickQuestionService questionService;
    private final ISysAreaProvideService sysAreaProvideService;

    @XxlJob(value="specialistCountTask-countTheNumber")
    @Transactional(propagation=Propagation.REQUIRED)
    public void countTheNumber() {
        List<Object> list = new ArrayList<SpecialistAnswerCount>();
        List<SpecialistAnswerCount> all = this.getSpecialistAnswerCountByType(null);
        List<SpecialistAnswerCount> list1 = this.getSpecialistAnswerCountByType(true);
        List<SpecialistAnswerCount> list2 = this.getSpecialistAnswerCountByType(false);
        list.addAll(all);
        list.addAll(list1);
        list.addAll(list2);
        list = list.stream().sorted(Comparator.comparingLong(SpecialistAnswerCount::getAreaId)).collect(Collectors.toList());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getIsValid, (Object)true)).set(BaseEntity::getIsValid, (Object)false);
        this.answerCountService.update((Wrapper)updateWrapper);
        this.answerCountService.saveBatch(list);
    }

    private List<SpecialistAnswerCount> getSpecialistAnswerCountByType(Boolean specialistType) {
        Byte type = specialistType == null ? (byte)2 : (specialistType != false ? (byte)1 : 0);
        HashMap<Long, SpecialistAnswerCount> map = new HashMap<Long, SpecialistAnswerCount>();
        List<Long> questionIdList = this.questionService.getQuestionIdBySpecialistType(specialistType);
        XxlJobHelper.log((String)"{} \u9700\u5237\u65b0\u7edf\u8ba1\u95ee\u9898\u6570\uff1a{}", (Object[])new Object[]{type, questionIdList.size()});
        int batchSize = 2000;
        for (int i = 0; i < questionIdList.size(); i += batchSize) {
            List<Long> subList = questionIdList.subList(i, Math.min(i + batchSize, questionIdList.size()));
            SpecialistAnswerCount provinceCount = this.specialistInfoService.getProvinceCount(specialistType);
            provinceCount.setSpecialistType(type);
            map.put(provinceCount.getAreaId(), provinceCount);
            List<SpecialistAnswerCount> cityCount = this.specialistInfoService.getCityCount(specialistType);
            Byte finalType = type;
            cityCount.forEach(count -> {
                count.setSpecialistType(finalType);
                map.put(count.getAreaId(), (SpecialistAnswerCount)count);
            });
            SpecialistAnswerCount answerProvinceCount = this.questionRecordService.getAnswerProvinceCount(subList);
            ((SpecialistAnswerCount)map.get(answerProvinceCount.getAreaId())).setAnswerCount(answerProvinceCount.getAnswerCount());
            List<SpecialistAnswerCount> answerCityCount = this.questionRecordService.getAnswerCityCount(subList);
            answerCityCount.forEach(answerCount -> {
                SpecialistAnswerCount count = (SpecialistAnswerCount)map.get(answerCount.getAreaId());
                if (count != null) {
                    count.setAnswerCount(answerCount.getAnswerCount());
                }
            });
            List<SpecialistQuestionCount> questionProvinceCount = this.questionRecordService.getQuestionProvinceCount(subList);
            List<SpecialistQuestionCount> questionCityCount = this.questionRecordService.getQuestionCityCount(subList);
            ((SpecialistAnswerCount)map.get(provinceCount.getAreaId())).setReceiveCount(Integer.valueOf(questionProvinceCount.size()));
            for (Map.Entry entry : questionCityCount.stream().collect(Collectors.groupingBy(SpecialistQuestionCount::getAreaId, Collectors.mapping(SpecialistQuestionCount::getQuestionId, Collectors.toList()))).entrySet()) {
                ((SpecialistAnswerCount)map.get(entry.getKey())).setReceiveCount(Integer.valueOf(entry.getValue().size()));
            }
            Integer provinceNoResponseCount = this.processNoResponseCount(questionProvinceCount);
            ((SpecialistAnswerCount)map.get(provinceCount.getAreaId())).setNoResponseCount(provinceNoResponseCount);
            Map<Long, Integer> cityNoResponseCounts = this.processCityNoResponseCounts(questionCityCount);
            cityNoResponseCounts.forEach((areaId, noResponseCount) -> {
                SpecialistAnswerCount count = (SpecialistAnswerCount)map.get(areaId);
                if (count != null) {
                    count.setNoResponseCount(noResponseCount);
                }
            });
        }
        return map.values().stream().collect(Collectors.toList());
    }

    private Integer processNoResponseCount(List<SpecialistQuestionCount> questionCounts) {
        List<Long> questionIds = questionCounts.stream().filter(item -> Boolean.TRUE.equals(item.getNoResponseStatus())).map(SpecialistQuestionCount::getQuestionId).collect(Collectors.toList());
        if (questionIds.isEmpty()) {
            return 0;
        }
        List<Object> filteredCounts = this.questionRecordService.filteredProvinceCount(questionIds);
        filteredCounts = filteredCounts.stream().filter(item -> Boolean.FALSE.equals(item.getResponseStatus())).collect(Collectors.toList());
        return filteredCounts.size();
    }

    private Map<Long, Integer> processCityNoResponseCounts(List<SpecialistQuestionCount> questionCounts) {
        Map groupedQuestionIdsByAreaId = questionCounts.stream().filter(item -> Boolean.TRUE.equals(item.getNoResponseStatus())).collect(Collectors.groupingBy(SpecialistQuestionCount::getAreaId, Collectors.mapping(SpecialistQuestionCount::getQuestionId, Collectors.toList())));
        HashMap<Long, Integer> cityNoResponseCounts = new HashMap<Long, Integer>();
        groupedQuestionIdsByAreaId.forEach((areaId, questionIds) -> {
            List<Object> filteredCounts = this.questionRecordService.filteredCityCount((Long)areaId, (List<Long>)questionIds);
            filteredCounts = filteredCounts.stream().filter(item -> Boolean.FALSE.equals(item.getResponseStatus())).collect(Collectors.toList());
            cityNoResponseCounts.put((Long)areaId, filteredCounts.size());
        });
        return cityNoResponseCounts;
    }

    @Generated
    public SpecialistCountTask(ISpecialistInfoService specialistInfoService, ISpecialistAnswerCountService answerCountService, ISpecialistQuestionRecordService questionRecordService, ISpecialistQuickQuestionService questionService, ISysAreaProvideService sysAreaProvideService) {
        this.specialistInfoService = specialistInfoService;
        this.answerCountService = answerCountService;
        this.questionRecordService = questionRecordService;
        this.questionService = questionService;
        this.sysAreaProvideService = sysAreaProvideService;
    }
}

