/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.task;

import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AutoCloseQuestionTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoCloseQuestionTask.class);
    private final ISpecialistQuickQuestionService quickQuestionService;

    @XxlJob(value="questionTask-close-expired-questions")
    @Transactional
    public void checkAndCloseExpiredQuestions() {
        LocalDateTime currDate = LocalDateTime.now();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SpecialistQuickQuestion::getIsValid, (Object)Boolean.TRUE)).eq(SpecialistQuickQuestion::getStatus, (Object)SpecialistQuestionStatusEnum.UNCOMPLETED.getKey())).lt(SpecialistQuickQuestion::getAutoCloseTime, (Object)currDate);
        List questionList = this.quickQuestionService.list((Wrapper)wrapper);
        for (SpecialistQuickQuestion question : questionList) {
            SpecialistQuickQuestionModel queParam = new SpecialistQuickQuestionModel();
            queParam.setQuestionId(question.getId());
            SpecialistUser user = new SpecialistUser();
            user.setIsSpecialist(Boolean.FALSE);
            queParam.setUser(user);
            this.quickQuestionService.finishQuestion(queParam);
        }
    }

    @Generated
    public AutoCloseQuestionTask(ISpecialistQuickQuestionService quickQuestionService) {
        this.quickQuestionService = quickQuestionService;
    }
}

