/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.tt.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.tt.constants.SpecialistConstants;
import cn.smarthse.tt.dao.tt.SpecialistInfoMapper;
import cn.smarthse.tt.dao.tt.SpecialistQuestionRecordMapper;
import cn.smarthse.tt.dao.tt.SpecialistQuickCommunicateMapper;
import cn.smarthse.tt.dao.tt.SpecialistQuickQuestionMapper;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.SpecialistQuickCommunicate;
import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.enums.SpecialistExpertiseAreaEnum;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.framework.bean.SensitiveWordFiltering;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.service.sys.ICompanyService;
import cn.smarthse.tt.service.sys.ISensitiveWordFilteringService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickCommunicateService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistInfoVo;
import cn.smarthse.tt.vo.SpecialistQuickQuestionVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecialistQuickQuestionServiceImpl
extends ServiceImpl<SpecialistQuickQuestionMapper, SpecialistQuickQuestion>
implements ISpecialistQuickQuestionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecialistQuickQuestionServiceImpl.class);
    @Value(value="${sendExpertSmsEnable}")
    private Boolean sendSms;
    private final SpecialistQuestionRecordMapper questionRecordMapper;
    private final SpecialistQuickCommunicateMapper communicateMapper;
    private final SpecialistInfoMapper specialistInfoMapper;
    private final ISensitiveWordFilteringService filteringService;
    private final OssClientBean ossBean;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    @DubboReference
    private ISMSProviderWelinkService smsProviderWelinkService;
    @Autowired
    @Lazy
    private ISpecialistQuickCommunicateService communicateService;
    @Autowired
    private ISpecialistQuestionRecordService questionRecordService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private ICompanyService comService;
    private final RedisClient redisClient;
    private static final String NEW_REPLY_VIEW = "hasNewReplyNoBeenViewed";
    private static final String SMS_CONTENT = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u63d0\u9192\uff01\u60a8\u5728\u201c\u536b\u4f01\u76f4\u901a\u8f66\u201d\u6536\u5230\u65b0\u7684\u54a8\u8be2\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u201c\u6d59\u91cc\u529e-\u536b\u4f01\u5728\u7ebf-\u536b\u4f01\u76f4\u901a\u8f66\u201d\u5904\u7406\uff01";

    @Override
    public PageInfo<SpecialistQuickQuestionVo> getSpecialistQuestionPage(JqGridParam pageParam, SpecialistQuickQuestionModel queParam) {
        SpecialistUser user = queParam.getUser();
        if (user != null) {
            boolean isSpecialist = user.getIsSpecialist();
            queParam.setIsSpecialist(Boolean.valueOf(isSpecialist));
            if (isSpecialist) {
                queParam.setExpertId(user.getSpecialistId());
            } else {
                queParam.setAskId(user.getId());
            }
        }
        Page questionPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<SpecialistQuickQuestionVo> questionList = ((SpecialistQuickQuestionMapper)this.baseMapper).getSpecialistQuestionList(queParam);
        this.judgeQuestionReplyRead(user, questionList);
        SpecialistQuickQuestionServiceImpl.setQuestionStatusByUser(user, questionList);
        SpecialistQuickQuestionServiceImpl.setQuestionEnumName(questionList);
        SpecialistQuickQuestionServiceImpl.setRelativeTime(questionList);
        return new PageInfo((List)questionPage);
    }

    @Override
    public SpecialistQuickQuestionVo getQuestionDetail(SpecialistUser user, Long id) {
        List<SpecialistQuickQuestionVo> questionList;
        SpecialistQuickQuestionModel queParam = new SpecialistQuickQuestionModel();
        queParam.setId(id);
        Boolean isSpecialist = null;
        if (user != null) {
            isSpecialist = user.getIsSpecialist();
            queParam.setIsSpecialist(isSpecialist);
            if (isSpecialist.booleanValue()) {
                queParam.setExpertId(user.getSpecialistId());
            } else {
                queParam.setAskId(user.getId());
            }
        }
        if (CollUtil.isEmpty(questionList = ((SpecialistQuickQuestionMapper)this.baseMapper).getSpecialistQuestionList(queParam))) {
            throw new ServiceException("\u5f53\u524d\u95ee\u9898\u4e0d\u5b58\u5728\uff01");
        }
        this.judgeQuestionReplyRead(user, questionList);
        SpecialistQuickQuestionServiceImpl.setQuestionStatusByUser(user, questionList);
        SpecialistQuickQuestionServiceImpl.setQuestionEnumName(questionList);
        SpecialistQuickQuestionServiceImpl.setRelativeTime(questionList);
        this.setFileInfo(questionList);
        return questionList.get(0);
    }

    private void setFileInfo(List<SpecialistQuickQuestionVo> questionList) {
        for (SpecialistQuickQuestionVo questionInfo : questionList) {
            if (!StringUtils.isNotBlank((CharSequence)questionInfo.getFile())) continue;
            questionInfo.setFileList(this.sysFileProvideService.getListByIds(questionInfo.getFile()));
        }
    }

    private void setOperationFileInfo(List<SpecialistQuickQuestionVo> questionList) {
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        questionList.forEach(que -> {
            String fileIds = que.getFile();
            if (CharSequenceUtil.isNotBlank((CharSequence)fileIds)) {
                List oneIdList = CharSequenceUtil.splitTrim((CharSequence)fileIds, (char)',').stream().map(Convert::toLong).collect(Collectors.toList());
                fileIdList.addAll(oneIdList);
            }
        });
        List fileList = fileIdList.isEmpty() ? Collections.emptyList() : this.communicateMapper.selectFileInfoBatch(fileIdList);
        Map<Long, String> fileIdNameMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, SysFileModel::getFileName, (a, b) -> b));
        Map<Long, String> fileIdUrlMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, file -> this.ossBean.getUrl(file.getOssUrl()), (a, b) -> b));
        for (SpecialistQuickQuestionVo que2 : questionList) {
            String fileIds = que2.getFile();
            if (!CharSequenceUtil.isNotBlank((CharSequence)fileIds)) continue;
            List oneFileIdList = CharSequenceUtil.splitTrim((CharSequence)fileIds, (char)',').stream().map(Convert::toLong).collect(Collectors.toList());
            List oneFileList = oneFileIdList.stream().map(i -> new SysFileModel().setId(i).setFileName((String)fileIdNameMap.get(i)).setOssUrl((String)fileIdUrlMap.get(i))).collect(Collectors.toList());
            que2.setFileList(Optional.of(oneFileList).orElse(Collections.emptyList()));
        }
    }

    private static void setQuestionStatusByUser(SpecialistUser user, List<SpecialistQuickQuestionVo> questionList) {
        if (user != null) {
            Boolean isSpecialist = user.getIsSpecialist();
            if (isSpecialist.booleanValue()) {
                return;
            }
            for (SpecialistQuickQuestionVo que : questionList) {
                if (!Objects.equals(que.getStatus(), SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey()) && !Objects.equals(que.getStatus(), SpecialistQuestionStatusEnum.NO_RESPONSE.getKey())) continue;
                que.setStatus(SpecialistQuestionStatusEnum.UNCOMPLETED.getKey());
            }
        }
    }

    private static void setQuestionEnumName(List<SpecialistQuickQuestionVo> questionList) {
        if (CollUtil.isNotEmpty(questionList)) {
            questionList.forEach(q -> q.setStatusName(SpecialistQuestionStatusEnum.getValue((Integer)q.getStatus())));
            questionList.forEach(q -> q.setTypeName(SpecialistExpertiseAreaEnum.getName((String)Convert.toStr((Object)q.getType()))));
        }
    }

    private static void setRelativeTime(List<SpecialistQuickQuestionVo> questionList) {
        if (CollUtil.isNotEmpty(questionList)) {
            questionList.forEach(que -> que.setRelativeTime(SpecialistQuickQuestionServiceImpl.getRelativeTime(que.getCreateDate())));
        }
    }

    private void filterSensitiveWords(List<SpecialistQuickQuestionVo> questionList) {
        for (SpecialistQuickQuestionVo que : questionList) {
            String content;
            SensitiveWordFiltering contentFilter;
            String title = que.getTitle();
            SensitiveWordFiltering titleFilter = this.filteringService.sensitiveWordFiltering(title);
            if (titleFilter != null && titleFilter.getHasSensitiveWord().booleanValue()) {
                que.setTitle(titleFilter.getContent());
            }
            if ((contentFilter = this.filteringService.sensitiveWordFiltering(content = que.getContent())) == null || !contentFilter.getHasSensitiveWord().booleanValue()) continue;
            que.setContent(contentFilter.getContent());
        }
    }

    @Override
    @Transactional
    public Pair<Integer, String> askQuestion(SpecialistQuickQuestionModel queParam) {
        Boolean hasUnFinish;
        SpecialistUser user = queParam.getUser();
        Long cid = queParam.getCid();
        Long askId = user.getId();
        String title = queParam.getTitle();
        String content = queParam.getContent();
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (askId == null) {
            throw new ServiceException("\u63d0\u95ee\u4ebaid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (CharSequenceUtil.isBlank((CharSequence)title)) {
            throw new ServiceException("\u63d0\u95ee\u6807\u9898\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (CharSequenceUtil.isBlank((CharSequence)content)) {
            throw new ServiceException("\u63d0\u95ee\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Boolean isSpecialist = user.getIsSpecialist();
        if (!isSpecialist.booleanValue() && (hasUnFinish = this.hasUnFinishQuestion(user)).booleanValue()) {
            throw new ServiceException("\u5982\u9700\u63d0\u51fa\u65b0\u7684\u95ee\u9898\uff0c\u8bf7\u5148\u81f3\u3010\u6211\u7684\u63d0\u95ee\u3011\u5173\u95ed\u672a\u5b8c\u6210\u7684\u95ee\u9898\uff01");
        }
        Long expertId = queParam.getExpertId();
        if (expertId == null) {
            Long matchExpertId = this.smartMatchExpertId(cid, queParam.getType());
            if (matchExpertId == null) {
                return new Pair((Object)ResponseStateEnum.fail.getValue(), (Object)"\u4eca\u65e5\u56de\u7b54\u95ee\u9898\u6b21\u6570\u5df2\u6ee1\uff0c\u8bf7\u660e\u65e5\u518d\u6765\uff01");
            }
            queParam.setExpertId(matchExpertId);
            queParam.setProperty(Byte.valueOf((byte)1));
        } else {
            SpecialistInfoVo expert = this.specialistInfoMapper.getExpertCanReplyInfo(expertId);
            if (expert == null) {
                throw new ServiceException("\u6b64\u4e13\u5bb6\u4e0d\u5b58\u5728\u6216\u5df2\u51fa\u5e93\uff01");
            }
            Boolean canReply = expert.getCanReply();
            if (!canReply.booleanValue()) {
                return new Pair((Object)ResponseStateEnum.fail.getValue(), (Object)"\u6b64\u4e13\u5bb6\u4eca\u65e5\u56de\u7b54\u95ee\u9898\u6b21\u6570\u5df2\u6ee1\uff0c\u8bf7\u660e\u65e5\u518d\u6765\uff01");
            }
            queParam.setProperty(Byte.valueOf((byte)2));
        }
        SpecialistQuickQuestion q = new SpecialistQuickQuestion();
        BeanUtils.copyProperties((Object)queParam, (Object)q);
        q.setId(Long.valueOf(IdWorker.getId()));
        q.setStatus(SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey());
        q.setAskId(askId);
        q.setCreateBy(q.getAskId());
        q.setUpdatedBy(q.getAskId());
        ((SpecialistQuickQuestionMapper)this.baseMapper).insert(q);
        try {
            this.questionRecordService.setReceiveSpecialist(q.getId(), null, queParam.getExpertId(), q.getAskId());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u95ee\u9898\u548c\u4e13\u5bb6\u7684\u5173\u8054\u4fe1\u606f\u5931\u8d25::", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u95ee\u9898\u548c\u4e13\u5bb6\u7684\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return new Pair((Object)ResponseStateEnum.success.getValue(), (Object)"\u6210\u529f");
    }

    @Override
    public Boolean hasUnFinishQuestion(SpecialistUser user) {
        Boolean isSpecialist = user.getIsSpecialist();
        if (isSpecialist == null || isSpecialist.booleanValue()) {
            throw new ServiceException("\u975e\u4e2a\u4eba\u767b\u5f55\uff01");
        }
        Long askId = user.getId();
        LambdaQueryWrapper quesWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)quesWrapper.in(SpecialistQuickQuestion::getStatus, (Collection)ListUtil.toList((Object[])new Integer[]{SpecialistQuestionStatusEnum.UNCOMPLETED.getKey(), SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey(), SpecialistQuestionStatusEnum.NO_RESPONSE.getKey()}))).eq(SpecialistQuickQuestion::getAskId, (Object)askId)).eq(SpecialistQuickQuestion::getIsValid, (Object)Boolean.TRUE);
        List unFinishQuesList = this.list((Wrapper)quesWrapper);
        return CollUtil.isNotEmpty((Collection)unFinishQuesList);
    }

    @Override
    public SpecialistQuickQuestion getLastQuestion(Long userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SpecialistQuickQuestion::getAskId, (Object)userId)).eq(SpecialistQuickQuestion::getIsValid, (Object)Boolean.TRUE)).orderByDesc(SpecialistQuickQuestion::getCreateDate)).last("LIMIT 1");
        return (SpecialistQuickQuestion)this.getOne((Wrapper)wrapper);
    }

    @Override
    public Long smartMatchExpertId(Long cid, Integer type) {
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (type == null) {
            throw new ServiceException("\u95ee\u9898\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        CompanySuperviseModel company = this.companyService.getCompanyInfoById(cid);
        if (company == null) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        Long regionId = company.getAreaId();
        AreaModel region = this.areaProvideService.getAreaById(regionId);
        Long provinceId = region.getProvinceId();
        Long cityId = region.getCityId();
        List<Object> replyExpertList = this.specialistInfoMapper.getCanReplySpecialistInfoList();
        log.debug("step1:\u67e5\u8be2\u4eca\u65e5\u6240\u6709\u53ef\u56de\u7b54\u4e13\u5bb6:{}", replyExpertList.stream().map(SpecialistInfoVo::getId).collect(Collectors.toList()));
        List regionIdList = replyExpertList.stream().map(SpecialistInfoVo::getAreaId).collect(Collectors.toList());
        List regionList = this.areaProvideService.getAreaListByIds(CollUtil.join(regionIdList, (CharSequence)","));
        Map regionMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, Function.identity(), (v1, v2) -> v1));
        Long expertId = null;
        replyExpertList = replyExpertList.stream().filter(e -> {
            if (Objects.equals(e.getId(), SpecialistConstants.SYS_SPECIALIST_ID)) {
                return Boolean.TRUE;
            }
            if (regionMap.get(e.getAreaId()) == null) {
                return Boolean.FALSE;
            }
            return Objects.equals(((AreaModel)regionMap.get(e.getAreaId())).getProvinceId(), provinceId) && Objects.equals(((AreaModel)regionMap.get(e.getAreaId())).getCityId(), cityId);
        }).collect(Collectors.toList());
        log.debug("step2:\u6392\u9664\u4e0d\u540c\u5c5e\u5730\u7684\u4e13\u5bb6-\u4f46\u662f\u8981\u4fdd\u7559\u7cfb\u7edf\u4e13\u5bb6\uff08\u6392\u9664\u975e\u767b\u5f55\u7528\u6237\u6240\u5728<\u7701/\u5e02>\u7684\u4e13\u5bb6\uff09\u3002:{}", replyExpertList.stream().map(SpecialistInfoVo::getId).collect(Collectors.toList()));
        List expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getType(), (byte)1)).collect(Collectors.toList());
        log.debug("step3:\u4e00\u7ea7\uff08\u4e00\u822c+\u515c\u5e95\uff09\u4e13\u5bb6\u3002:{}", expertList.stream().map(SpecialistInfoVo::getId).collect(Collectors.toList()));
        if (CollUtil.isEmpty(expertList)) {
            expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getType(), (byte)2)).collect(Collectors.toList());
            log.debug("step4:\u4e00\u7ea7\u4e0d\u5b58\u5728\uff0c\u90a3\u5c31\u7b5b\u9009\u4e8c\u7ea7\u54cd\u5e94\u4e13\u5bb6\u3002:{}", expertList.stream().map(SpecialistInfoVo::getId).collect(Collectors.toList()));
        }
        if (CollUtil.isEmpty(expertList)) {
            expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getId(), SpecialistConstants.SYS_SPECIALIST_ID)).collect(Collectors.toList());
            log.debug("step5:\u4e8c\u7ea7\u4e0d\u5b58\u5728\uff0c\u5c31\u7ed9\u5efa\u5b89:{}", expertList);
        }
        if (CollUtil.isNotEmpty(expertList)) {
            CollUtil.sort(expertList, Comparator.comparing(e -> SpecialistQuickQuestionServiceImpl.domainMatch(e.getExpertiseArea(), type) ? 0 : 1).thenComparing(SpecialistInfoVo::getReplyNum).thenComparing(SpecialistInfoVo::getFullnameInitial));
            expertId = ((SpecialistInfoVo)expertList.get(0)).getId();
        }
        log.debug("step6:\u6392\u5e8f\u53d6\u6700\u9002\u5408\u56de\u7b54\u95ee\u9898\u7684\u4e13\u5bb6:{}", expertId);
        return expertId;
    }

    @Override
    public Long transferAndMatchExpertId(SpecialistQuestionRecord record) {
        SpecialistInfo specialistInfo = this.specialistInfoMapper.getById(record.getTransferSpecialistId());
        AreaModel region = this.areaProvideService.getAreaById(specialistInfo.getAreaId());
        Long provinceId = region.getProvinceId();
        Long cityId = region.getCityId();
        List<Object> replyExpertList = this.specialistInfoMapper.getCanReplySpecialistInfoList();
        replyExpertList = replyExpertList.stream().filter(e -> Objects.equals(e.getId(), SpecialistConstants.SYS_SPECIALIST_ID) || e.getIsEntering() != null && e.getIsEntering() != false).collect(Collectors.toList());
        List regionIdList = replyExpertList.stream().map(SpecialistInfoVo::getAreaId).collect(Collectors.toList());
        List regionList = this.areaProvideService.getAreaListByIds(CollUtil.join(regionIdList, (CharSequence)","));
        Map regionMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, Function.identity(), (v1, v2) -> v1));
        Long expertId = null;
        List<SpecialistInfoVo> specialistInfos = this.questionRecordService.getSpecialistInfos(record.getQuestionId());
        List<Object> idList = new ArrayList();
        long citySupervise = 0L;
        long provinceCount = 0L;
        if (CollectionUtils.isNotEmpty(specialistInfos)) {
            idList = specialistInfos.stream().map(SpecialistInfoVo::getId).collect(Collectors.toList());
            citySupervise = specialistInfos.stream().filter(e -> Objects.equals(e.getType(), (byte)1) && SpecialistQuickQuestionServiceImpl.isSuperviseExpert(e)).count();
            provinceCount = specialistInfos.stream().filter(e -> Objects.equals(e.getType(), (byte)2)).count();
        }
        int level = 0;
        level = provinceCount == 0L && citySupervise == 0L ? 1 : (provinceCount == 0L ? 2 : 3);
        List<Object> expertList = new ArrayList();
        List<Object> finalIdList = idList;
        List<SpecialistInfoVo> cityExpertList = replyExpertList.stream().filter(e -> {
            AreaModel areaModel = (AreaModel)regionMap.get(e.getAreaId());
            if (areaModel != null && Objects.equals(areaModel.getProvinceId(), provinceId) && Objects.equals(areaModel.getCityId(), cityId) && !finalIdList.contains(e.getId())) {
                if (record.getSpecialistFieldType() == null) {
                    return true;
                }
                if (Objects.equals(e.getType(), (byte)1) && SpecialistQuickQuestionServiceImpl.isSuperviseExpert(e)) {
                    return true;
                }
                return SpecialistQuickQuestionServiceImpl.domainMatch(e.getExpertiseArea(), record.getSpecialistFieldType());
            }
            return false;
        }).collect(Collectors.toList());
        List<SpecialistInfoVo> provinceExpertList = replyExpertList.stream().filter(e -> {
            AreaModel areaModel = (AreaModel)regionMap.get(e.getAreaId());
            if (areaModel != null && Objects.equals(areaModel.getProvinceId(), provinceId) && !finalIdList.contains(e.getId()) && e.getType() == 2) {
                if (record.getSpecialistFieldType() == null) {
                    return true;
                }
                return SpecialistQuickQuestionServiceImpl.domainMatch(e.getExpertiseArea(), record.getSpecialistFieldType());
            }
            return Objects.equals(e.getId(), SpecialistConstants.SYS_SPECIALIST_ID);
        }).collect(Collectors.toList());
        List systemExpertList = replyExpertList.stream().filter(e -> Objects.equals(e.getId(), SpecialistConstants.SYS_SPECIALIST_ID)).collect(Collectors.toList());
        if (Objects.equals(record.getTransferType(), 1)) {
            if (Objects.equals(record.getReasonType(), 1)) {
                if (provinceCount == 0L && idList.size() < 2) {
                    expertList = this.matchLevel2(cityExpertList, expertList);
                    expertList = this.matchLevel1(cityExpertList, expertList);
                } else if (level == 1) {
                    expertList = this.matchLevel1(cityExpertList, expertList);
                    expertList = this.matchLevel2(cityExpertList, expertList);
                } else if (level == 2) {
                    expertList = this.matchLevel2(cityExpertList, expertList);
                }
                expertList = this.matchLevel3(provinceExpertList, expertList);
            } else if (Objects.equals(record.getReasonType(), 2)) {
                expertList = level == 1 || level == 2 ? this.matchLevel3(provinceExpertList, expertList) : systemExpertList;
            }
        } else if (Objects.equals(record.getTransferType(), 2)) {
            if (level == 1) {
                expertList = this.matchLevel2(cityExpertList, expertList);
                expertList = this.matchLevel3(provinceExpertList, expertList);
            } else if (level == 2) {
                expertList = this.matchLevel3(provinceExpertList, expertList);
            }
        }
        if (CollUtil.isEmpty(expertList)) {
            expertList = systemExpertList;
        }
        if (CollUtil.isNotEmpty(expertList)) {
            CollUtil.sort(expertList, Comparator.comparing(e -> SpecialistQuickQuestionServiceImpl.domainMatch(e.getExpertiseArea(), record.getSpecialistFieldType()) ? 0 : 1).thenComparing(SpecialistInfoVo::getReplyNum).thenComparing((e1, e2) -> e2.getFullname().compareToIgnoreCase(e1.getFullname())));
            expertId = ((SpecialistInfoVo)expertList.get(0)).getId();
        }
        if (expertId == null) {
            expertId = SpecialistConstants.SYS_SPECIALIST_ID;
        }
        return expertId;
    }

    private List<SpecialistInfoVo> matchLevel3(List<SpecialistInfoVo> replyExpertList, List<SpecialistInfoVo> expertList) {
        if (CollUtil.isEmpty(expertList)) {
            expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getType(), (byte)2)).collect(Collectors.toList());
        }
        return expertList;
    }

    private List<SpecialistInfoVo> matchLevel2(List<SpecialistInfoVo> replyExpertList, List<SpecialistInfoVo> expertList) {
        if (CollUtil.isEmpty(expertList)) {
            expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getType(), (byte)1) && SpecialistQuickQuestionServiceImpl.isSuperviseExpert(e)).collect(Collectors.toList());
        }
        return expertList;
    }

    private List<SpecialistInfoVo> matchLevel1(List<SpecialistInfoVo> replyExpertList, List<SpecialistInfoVo> expertList) {
        if (CollUtil.isEmpty(expertList)) {
            expertList = replyExpertList.stream().filter(e -> Objects.equals(e.getType(), (byte)1) && !SpecialistQuickQuestionServiceImpl.isSuperviseExpert(e)).collect(Collectors.toList());
        }
        return expertList;
    }

    @Override
    @Transactional
    public void finishQuestion(SpecialistQuickQuestionModel queParam) {
        Boolean isSpecialist;
        Long expertId;
        if (queParam == null || queParam.getQuestionId() == null) {
            throw new ServiceException("\u95ee\u9898id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long questionId = queParam.getQuestionId();
        SpecialistUser user = queParam.getUser();
        if (user != null) {
            expertId = user.getSpecialistId();
            isSpecialist = user.getIsSpecialist();
        } else {
            expertId = queParam.getExpertId();
            isSpecialist = expertId != null && Objects.equals(expertId, SpecialistConstants.SYS_SPECIALIST_ID);
        }
        LambdaQueryWrapper commWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)commWrapper.eq(SpecialistQuickCommunicate::getQuestionId, (Object)questionId)).eq(SpecialistQuickCommunicate::getType, (Object)2)).eq(SpecialistQuickCommunicate::getIsValid, (Object)Boolean.TRUE)).last("LIMIT 1");
        SpecialistQuestionStatusEnum status = SpecialistQuestionStatusEnum.COMPLETED;
        if (isSpecialist.booleanValue()) {
            commWrapper.eq(SpecialistQuickCommunicate::getSpecialistId, (Object)expertId);
            SpecialistQuickCommunicate currentExpertReply = (SpecialistQuickCommunicate)this.communicateService.getOne((Wrapper)commWrapper);
            if (currentExpertReply == null) {
                throw new ServiceException("\u4e13\u5bb6\u7b2c\u4e00\u6b21\u56de\u7b54\u95ee\u9898\u4e4b\u540e\uff0c\u624d\u53ef\u70b9\u51fb\u5b8c\u6210\u95ee\u9898\uff01");
            }
        } else {
            SpecialistQuickCommunicate anyExpertReply = (SpecialistQuickCommunicate)this.communicateService.getOne((Wrapper)commWrapper);
            if (anyExpertReply == null) {
                status = SpecialistQuestionStatusEnum.INVALID;
            }
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(SpecialistQuickQuestion.class);
        ((LambdaUpdateWrapper)wrapper.eq(SpecialistQuickQuestion::getId, (Object)questionId)).set(SpecialistQuickQuestion::getStatus, (Object)status.getKey());
        this.update((Wrapper)wrapper);
        this.questionRecordService.setQuestionStatus(questionId, null, status.getKey());
    }

    @Override
    public PageInfo<SpecialistQuickQuestionVo> getQuestionListBySearch(JqGridParam pageParam, SpecialistQuickQuestionModel queParam) {
        this.preSetRegionInfo(queParam);
        Page questionPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<SpecialistQuickQuestionVo> questionList = ((SpecialistQuickQuestionMapper)this.baseMapper).getQuestionListBySearch(queParam);
        this.postSetRegionFullName(questionList);
        this.judgeExpertQuestionReplyRead(queParam.getExpertId(), questionList);
        questionList.forEach(this::processQuestion);
        return new PageInfo((List)questionPage);
    }

    @Override
    public SpecialistQuickQuestionVo getQuestionInfo(Long id, Long specialistId) {
        SpecialistQuickQuestionVo question = ((SpecialistQuickQuestionMapper)this.baseMapper).getQuestionInfo(id, specialistId);
        this.judgeExpertQuestionReplyRead(specialistId, Collections.singletonList(question));
        this.processQuestion(question);
        return question;
    }

    private void processQuestion(SpecialistQuickQuestionVo question) {
        if (question == null) {
            return;
        }
        question.setTypeName(SpecialistExpertiseAreaEnum.getName((String)Convert.toStr((Object)question.getType())));
        question.setStatusName(SpecialistQuestionStatusEnum.getValue((Integer)question.getStatus()));
        Integer questionStatus = question.getQuestionStatus();
        if (StringUtils.isNotBlank((CharSequence)question.getFile())) {
            question.setFileList(this.sysFileProvideService.getListByIds(question.getFile()));
        }
        if ((Objects.equals(questionStatus, SpecialistQuestionStatusEnum.UNCOMPLETED.getKey()) || Objects.equals(questionStatus, SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey()) || Objects.equals(questionStatus, SpecialistQuestionStatusEnum.NO_RESPONSE.getKey())) && question.getTransferSpecialistId() != null) {
            question.setQuestionStatus(Integer.valueOf(8));
            if (Boolean.TRUE.equals(question.getIsNoResponse())) {
                question.setQuestionStatus(Integer.valueOf(9));
            }
        }
    }

    @Override
    public JqGridData<CompanySuperviseModel> getCompanyPage(CompanySuperviseSearchModel comParam, SpecialistUser user, int page, int rows) {
        PageInfo companyPage = new PageInfo();
        if (CharSequenceUtil.isNotBlank((CharSequence)comParam.getName())) {
            companyPage = this.companyService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(comParam, page, rows, Boolean.valueOf(true));
        } else {
            List<CompanySuperviseModel> comList = ((SpecialistQuickQuestionMapper)this.baseMapper).selectCompanyByLoginUserId(user.getId());
            if (CollUtil.isNotEmpty(comList)) {
                companyPage.setList(comList);
                companyPage.setTotal((long)comList.size());
            } else {
                companyPage = this.companyService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(comParam, page, rows, Boolean.valueOf(true));
            }
        }
        if (CollUtil.isEmpty((Collection)companyPage.getList())) {
            return new JqGridData();
        }
        JqGridParam pageParam = new JqGridParam(rows, page);
        return new JqGridData(companyPage, pageParam);
    }

    @Override
    public List<Long> getQuestionIdBySpecialistType(Boolean specialistType) {
        return ((SpecialistQuickQuestionMapper)this.baseMapper).getQuestionIdBySpecialistType(specialistType);
    }

    @Override
    public void updateType(SpecialistQuickQuestion question) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SpecialistQuickQuestion.class).eq(SpecialistQuickQuestion::getId, (Object)question.getId())).set(SpecialistQuickQuestion::getType, (Object)question.getType());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void verifyCurrentExpertReplyOrFinish(SpecialistUser user) {
        Boolean isSpecialist = user.getIsSpecialist();
        if (isSpecialist.booleanValue()) {
            Long expertId = user.getSpecialistId();
            SpecialistInfoVo expert = this.specialistInfoMapper.getExpertCanReplyInfo(expertId);
            if (expert == null) {
                throw new ServiceException("\u6b64\u4e13\u5bb6\u4e0d\u5b58\u5728\u6216\u5df2\u51fa\u5e93\uff01");
            }
            Boolean canReply = expert.getCanReply();
            if (!canReply.booleanValue()) {
                throw new ServiceException("\u4eca\u65e5\u56de\u7b54\u95ee\u9898\u6b21\u6570\u5df2\u6ee1\uff0c\u8bf7\u660e\u65e5\u518d\u6765\uff01");
            }
        }
    }

    private void preSetRegionInfo(SpecialistQuickQuestionModel param) {
        if (param == null || param.getRegionId() == null) {
            return;
        }
        AreaModel region = this.sysAreaProvideService.getAreaById(param.getRegionId());
        if (region == null || region.getId() == null) {
            return;
        }
        param.setRegionLevel(region.getLevel());
    }

    public void postSetRegionFullName(List<SpecialistQuickQuestionVo> questionList) {
        if (CollUtil.isNotEmpty(questionList)) {
            Map<Long, String> regionMap = this.sysAreaProvideService.getAreaListByIds(questionList.stream().map(SpecialistQuickQuestionVo::getRegionId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","))).stream().collect(Collectors.toMap(AreaModel::getId, region -> switch (region.getLevel()) {
                case 0 -> "\u56fd\u5bb6";
                case 1 -> region.getProvinceName();
                case 2 -> region.getProvinceName() + "/" + region.getCityName();
                case 3 -> region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
                case 4 -> region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName() + "/" + region.getStreetName();
                default -> "";
            }));
            questionList.forEach(n -> n.setRegionFullName((String)regionMap.get(n.getRegionId())));
        }
    }

    private void judgeExpertQuestionReplyRead(Long expertId, List<SpecialistQuickQuestionVo> questionVoList) {
        if (expertId != null && CollUtil.isNotEmpty(questionVoList)) {
            SpecialistUser user = new SpecialistUser();
            user.setIsSpecialist(Boolean.TRUE);
            user.setSpecialistId(expertId);
            this.judgeQuestionReplyRead(user, questionVoList);
        }
    }

    private void judgeQuestionReplyRead(SpecialistUser user, List<SpecialistQuickQuestionVo> questionList) {
        Boolean isSpecialist;
        if (user != null && (isSpecialist = user.getIsSpecialist()) != null) {
            for (SpecialistQuickQuestionVo que : questionList) {
                Long questionId = que.getId();
                String key = isSpecialist != false ? "hasNewReplyNoBeenViewed:" + questionId + ":" + user.getSpecialistId() : "hasNewReplyNoBeenViewed:" + questionId + ":" + user.getId();
                que.setLatestReplyNoRead(Boolean.valueOf(this.redisClient.hasKey(key)));
            }
        }
    }

    private static boolean isSuperviseExpert(SpecialistInfoVo info) {
        return info.getIsFallback();
    }

    private static boolean domainMatch(String expertiseArea, Object type) {
        if (CharSequenceUtil.isNotBlank((CharSequence)expertiseArea)) {
            Object[] array = expertiseArea.split(",");
            return ArrayUtil.indexOf((Object[])array, (Object)Convert.toStr((Object)type)) != -1;
        }
        return Boolean.FALSE;
    }

    public static String getRelativeTime(Date date) {
        if (date == null) {
            return null;
        }
        long diffMil = new Date().getTime() - date.getTime();
        long diffSec = TimeUnit.MILLISECONDS.toSeconds(diffMil);
        long diffMin = TimeUnit.MILLISECONDS.toMinutes(diffMil);
        long diffHou = TimeUnit.MILLISECONDS.toHours(diffMil);
        long diffDay = TimeUnit.MILLISECONDS.toDays(diffMil);
        Object result = diffSec < 60L ? "\u521a\u521a" : (diffMin < 60L ? diffMin + "\u5206\u949f\u524d" : (diffHou < 24L ? diffHou + "\u5c0f\u65f6\u524d" : (diffDay < 5L ? diffDay + "\u5929\u524d" : DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"))));
        return result;
    }

    @Override
    public void sendSms(Long expertId) {
        if (expertId == null) {
            return;
        }
        SpecialistInfoVo expert = this.specialistInfoMapper.getSpecialistInfoById(expertId, false);
        if (expert == null) {
            throw new ServiceException("\u6b64\u4e13\u5bb6\u4e0d\u5b58\u5728\u6216\u5df2\u51fa\u5e93\uff01");
        }
        String userMobile = expert.getUserMobile();
        this.executorService.execute(() -> {
            try {
                if (this.sendSms != null && this.sendSms.booleanValue()) {
                    LocalTime start = LocalTime.of(8, 0);
                    LocalTime end = LocalTime.of(20, 0);
                    if (!StringUtils.isEmpty((CharSequence)userMobile)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(userMobile, SMS_CONTENT);
                        this.smsProviderWelinkService.sendOrDelaySms(map, start, end, Byte.valueOf((byte)0));
                    }
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25{}", (Object)e.getMessage());
            }
        });
    }

    @Generated
    public SpecialistQuickQuestionServiceImpl(SpecialistQuestionRecordMapper questionRecordMapper, SpecialistQuickCommunicateMapper communicateMapper, SpecialistInfoMapper specialistInfoMapper, ISensitiveWordFilteringService filteringService, OssClientBean ossBean, RedisClient redisClient) {
        this.questionRecordMapper = questionRecordMapper;
        this.communicateMapper = communicateMapper;
        this.specialistInfoMapper = specialistInfoMapper;
        this.filteringService = filteringService;
        this.ossBean = ossBean;
        this.redisClient = redisClient;
    }
}

