/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.tt.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.supervise.enums.sys.UserFromEnum;
import cn.smarthse.tt.constants.SpecialistConstants;
import cn.smarthse.tt.dao.tt.SpecialistInfoMapper;
import cn.smarthse.tt.dao.tt.SpecialistQuickCommunicateMapper;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.SpecialistQuickCommunicate;
import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.framework.bean.SensitiveWordFiltering;
import cn.smarthse.tt.model.SpecialistQuickCommunicateModel;
import cn.smarthse.tt.service.sys.ISensitiveWordFilteringService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickCommunicateService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistQuickCommunicateVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialistQuickCommunicateServiceImpl
extends ServiceImpl<SpecialistQuickCommunicateMapper, SpecialistQuickCommunicate>
implements ISpecialistQuickCommunicateService {
    private final ISpecialistQuestionRecordService questionRecordService;
    private final ISensitiveWordFilteringService filteringService;
    private final OssClientBean ossBean;
    private final RedisClient redisClient;
    private static final String NEW_REPLY_VIEW = "hasNewReplyNoBeenViewed";
    private static final Long AUTO_CLOSE_COUNTDOWN = 259200L;
    private static final List<String> SPECIAL_SUPERVISORY_ACCOUNT = Arrays.asList("superuser", "zjs003");
    @Autowired
    private ISpecialistQuickQuestionService quickQuestionService;
    @Autowired
    private SpecialistInfoMapper specialistInfoMapper;

    @Override
    public List<SpecialistQuickCommunicateVo> getSpecialistCommunicateList(SpecialistQuickCommunicateModel commParam) {
        if (commParam == null || commParam.getQuestionId() == null) {
            throw new ServiceException("\u63d0\u95eeid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long questionId = commParam.getQuestionId();
        SpecialistUser user = commParam.getUser();
        LambdaQueryWrapper queWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queWrapper.eq(SpecialistQuickQuestion::getId, (Object)questionId)).eq(SpecialistQuickQuestion::getIsValid, (Object)Boolean.TRUE);
        SpecialistQuickQuestion question = (SpecialistQuickQuestion)this.quickQuestionService.getOne((Wrapper)queWrapper);
        if (question == null) {
            throw new ServiceException("\u95ee\u9898\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper qrWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)qrWrapper.eq(SpecialistQuestionRecord::getQuestionId, (Object)questionId)).eq(SpecialistQuestionRecord::getIsValid, (Object)Boolean.TRUE);
        List questionRecordList = this.questionRecordService.list((Wrapper)qrWrapper);
        Long specialistId = null;
        String key = null;
        if (user != null) {
            Boolean isSpecialist = user.getIsSpecialist();
            if (isSpecialist.booleanValue()) {
                commParam.setIsSpecialist(Boolean.TRUE);
                specialistId = user.getSpecialistId();
                List<Long> specialistIdList = this.getSpecialistTransferHistory(questionRecordList, specialistId);
                commParam.setSpecialistIdList(specialistIdList);
                key = "hasNewReplyNoBeenViewed:" + questionId + ":" + specialistId;
            } else {
                commParam.setIsSpecialist(Boolean.FALSE);
                key = "hasNewReplyNoBeenViewed:" + questionId + ":" + user.getId();
            }
        } else {
            commParam.setIsSpecialist(Boolean.TRUE);
            specialistId = commParam.getSpecialistId();
            if (specialistId == null) {
                throw new ServiceException("\u4e13\u5bb6id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            List<Long> specialistIdList = this.getSpecialistTransferHistory(questionRecordList, specialistId);
            commParam.setSpecialistIdList(specialistIdList);
            if (Objects.equals(specialistId, SpecialistConstants.SYS_SPECIALIST_ID)) {
                key = "hasNewReplyNoBeenViewed:" + questionId + ":" + specialistId;
            }
        }
        if (key != null && this.redisClient.hasKey(key)) {
            this.redisClient.del(new String[]{key});
        }
        boolean maintenance = Objects.equals(commParam.getUserFrom(), UserFromEnum.MAINTENANCE.getCode());
        boolean specialSupervise = Objects.equals(commParam.getUserFrom(), UserFromEnum.SUPERVISE.getCode()) && SpecialistQuickCommunicateServiceImpl.inclusionMatch(SPECIAL_SUPERVISORY_ACCOUNT, commParam.getLoginAccountUserName());
        boolean match = specialistId != null && (maintenance || specialSupervise);
        List specialistIdList = commParam.getSpecialistIdList();
        if (maintenance || specialSupervise || !CollUtil.isNotEmpty((Collection)specialistIdList) || specialistIdList.contains(SpecialistConstants.SYS_SPECIALIST_ID)) {
            // empty if block
        }
        if (match) {
            Long currExpertId = specialistId;
            boolean transToSys = questionRecordList.stream().filter(qr -> Objects.equals(qr.getTransferSpecialistId(), currExpertId)).findFirst().map(qr -> Objects.equals(qr.getReceiveSpecialistId(), SpecialistConstants.SYS_SPECIALIST_ID)).orElse(Boolean.FALSE);
            if (transToSys && CollUtil.isNotEmpty((Collection)specialistIdList)) {
                specialistIdList.add(SpecialistConstants.SYS_SPECIALIST_ID);
                commParam.setSpecialistIdList(specialistIdList);
            }
        }
        List<SpecialistQuickCommunicateVo> commList = ((SpecialistQuickCommunicateMapper)this.baseMapper).getSpecialistCommunicateList(commParam);
        commList = SpecialistQuickCommunicateServiceImpl.filterTransferMessages(question, commList);
        this.setExpertFaceFileInfo(commList);
        commList.stream().filter(c -> Objects.equals(c.getType(), 0)).forEach(c -> c.setContent(c.getContent() + c.getPersonNameTemporary()));
        return commList;
    }

    public static List<SpecialistQuickCommunicateVo> filterTransferMessages(SpecialistQuickQuestion question, List<SpecialistQuickCommunicateVo> commList) {
        if (Objects.equals(question.getProperty(), (byte)1)) {
            commList = commList.stream().filter(c -> !Objects.equals(c.getType(), 0)).collect(Collectors.toList());
        }
        return commList;
    }

    private void setExpertFaceFileInfo(List<SpecialistQuickCommunicateVo> commList) {
        if (CollUtil.isEmpty(commList)) {
            return;
        }
        List<Long> fileIdList = commList.stream().map(SpecialistQuickCommunicateVo::getFaceId).filter(Objects::nonNull).collect(Collectors.toList());
        List fileList = fileIdList.isEmpty() ? Collections.emptyList() : ((SpecialistQuickCommunicateMapper)this.baseMapper).selectFileInfoBatch(fileIdList);
        Map<Long, String> fileIdNameMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, SysFileModel::getFileName, (a, b) -> b));
        Map<Long, String> fileIdUrlMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, file -> this.ossBean.getUrl(file.getOssUrl()), (a, b) -> b));
        for (SpecialistQuickCommunicateVo c : commList) {
            Long faceId = c.getFaceId();
            if (faceId == null) continue;
            SysFileModel faceFile = new SysFileModel().setId(faceId).setFileName(fileIdNameMap.get(faceId)).setOssUrl(fileIdUrlMap.get(faceId));
            c.setFaceFile(faceFile);
        }
    }

    private void filterSensitiveWords(List<SpecialistQuickCommunicateVo> commList) {
        for (SpecialistQuickCommunicateVo comm : commList) {
            String content = comm.getContent();
            SensitiveWordFiltering filter = this.filteringService.sensitiveWordFiltering(content);
            if (filter == null || !filter.getHasSensitiveWord().booleanValue()) continue;
            comm.setContent(filter.getContent());
        }
    }

    public List<Long> getSpecialistTransferHistory(List<SpecialistQuestionRecord> questionRecordList, Long specialistId) {
        List<Long> specialistIdList = new ArrayList<Long>();
        if (CollUtil.isEmpty(questionRecordList)) {
            specialistIdList.add(specialistId);
            return specialistIdList;
        }
        questionRecordList.sort(Comparator.comparing(SpecialistQuestionRecord::getCreateDate));
        for (SpecialistQuestionRecord qr : questionRecordList) {
            if (Objects.equals(qr.getReceiveSpecialistId(), specialistId)) {
                specialistIdList.add(specialistId);
                break;
            }
            if (qr.getReceiveSpecialistId() == null) continue;
            specialistIdList.add(qr.getReceiveSpecialistId());
        }
        if (CollUtil.isNotEmpty(specialistIdList) && !specialistIdList.contains(specialistId)) {
            specialistIdList = Collections.emptyList();
        }
        return specialistIdList;
    }

    @Override
    public void doReply(SpecialistQuickCommunicateModel commParam) {
        String key;
        boolean isTransfer;
        if (commParam == null || commParam.getQuestionId() == null) {
            throw new ServiceException("\u63d0\u95eeid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SpecialistUser user = commParam.getUser();
        if (user != null) {
            Boolean isSpecialist = user.getIsSpecialist();
            commParam.setType(Integer.valueOf(isSpecialist != false ? 2 : 1));
            commParam.setPersonId(isSpecialist != false ? user.getSpecialistId() : user.getId());
        } else {
            commParam.setType(Integer.valueOf(2));
        }
        Long questionId = commParam.getQuestionId();
        Integer type = commParam.getType();
        LambdaQueryWrapper quesWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)quesWrapper.eq(SpecialistQuickQuestion::getId, (Object)questionId)).eq(SpecialistQuickQuestion::getIsValid, (Object)Boolean.TRUE);
        SpecialistQuickQuestion ques = (SpecialistQuickQuestion)this.quickQuestionService.getOne((Wrapper)quesWrapper);
        if (ques == null) {
            throw new ServiceException("\u95ee\u9898\u4e0d\u5b58\u5728\uff01");
        }
        if (Objects.equals(ques.getStatus(), SpecialistQuestionStatusEnum.COMPLETED.getKey())) {
            throw new ServiceException("\u95ee\u9898\u5df2\u5b8c\u6210\uff0c\u4e0d\u53ef\u518d\u56de\u590d\uff01");
        }
        if (Objects.equals(ques.getStatus(), SpecialistQuestionStatusEnum.INVALID.getKey())) {
            throw new ServiceException("\u95ee\u9898\u5df2\u65e0\u6548\uff0c\u4e0d\u53ef\u518d\u56de\u590d\uff01");
        }
        SpecialistQuestionRecord currentQuestionExpert = this.isExpertAndCanReplyQuestion(user, questionId);
        LambdaQueryWrapper commWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)commWrapper.eq(SpecialistQuickCommunicate::getQuestionId, (Object)questionId)).eq(SpecialistQuickCommunicate::getSpecialistId, (Object)currentQuestionExpert.getReceiveSpecialistId())).eq(SpecialistQuickCommunicate::getIsValid, (Object)Boolean.TRUE)).orderByDesc(SpecialistQuickCommunicate::getCreateDate)).last("LIMIT 1");
        SpecialistQuickCommunicate currLatestComm = (SpecialistQuickCommunicate)this.getOne((Wrapper)commWrapper);
        boolean bl = isTransfer = currentQuestionExpert.getTransferSpecialistId() != null;
        if (isTransfer) {
            commWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)commWrapper.eq(SpecialistQuickCommunicate::getQuestionId, (Object)questionId)).eq(SpecialistQuickCommunicate::getSpecialistId, (Object)currentQuestionExpert.getTransferSpecialistId())).eq(SpecialistQuickCommunicate::getIsValid, (Object)Boolean.TRUE)).orderByDesc(SpecialistQuickCommunicate::getCreateDate)).last("LIMIT 1");
            SpecialistQuickCommunicate preLatestComm = (SpecialistQuickCommunicate)this.getOne((Wrapper)commWrapper);
            if (currLatestComm == null && preLatestComm != null && Objects.equals(type, 1) && Objects.equals(preLatestComm.getType(), 1)) {
                throw new ServiceException("\u8bf7\u7b49\u5f85\u79fb\u4ea4\u4e13\u5bb6\u54cd\u5e94\uff01");
            }
            if (currLatestComm != null && Objects.equals(type, currLatestComm.getType())) {
                throw new ServiceException("\u7b49\u5bf9\u65b9\u56de\u590d\u540e\u624d\u80fd\u518d\u56de\u590d\uff01");
            }
        } else {
            if (currLatestComm == null && Objects.equals(type, 1)) {
                throw new ServiceException("\u8bf7\u7b49\u5f85\u4e13\u5bb6\u54cd\u5e94\uff01");
            }
            if (currLatestComm != null && Objects.equals(type, currLatestComm.getType())) {
                throw new ServiceException("\u7b49\u5bf9\u65b9\u56de\u590d\u540e\u624d\u80fd\u518d\u56de\u590d\uff01");
            }
        }
        SpecialistQuickCommunicate comm = new SpecialistQuickCommunicate();
        BeanUtils.copyProperties((Object)commParam, (Object)comm);
        comm.setCreateBy(commParam.getPersonId());
        comm.setUpdatedBy(commParam.getPersonId());
        comm.setSpecialistId(currentQuestionExpert.getReceiveSpecialistId());
        ((SpecialistQuickCommunicateMapper)this.baseMapper).insert(comm);
        LambdaUpdateWrapper queWrapper = Wrappers.lambdaUpdate(SpecialistQuickQuestion.class);
        ((LambdaUpdateWrapper)queWrapper.eq(SpecialistQuickQuestion::getId, (Object)questionId)).set(SpecialistQuickQuestion::getStatus, (Object)SpecialistQuestionStatusEnum.UNCOMPLETED.getKey());
        this.quickQuestionService.update((Wrapper)queWrapper);
        if (Objects.equals(commParam.getType(), 2)) {
            this.questionRecordService.setQuestionStatus(questionId, currentQuestionExpert.getReceiveSpecialistId(), SpecialistQuestionStatusEnum.UNCOMPLETED.getKey());
        }
        this.set3DayCountdown(commParam, questionId);
        String string = type == 1 ? "hasNewReplyNoBeenViewed:" + questionId + ":" + comm.getSpecialistId() : (key = type == 2 ? "hasNewReplyNoBeenViewed:" + questionId + ":" + ques.getAskId() : null);
        if (key != null) {
            this.redisClient.set(key, (Object)1);
        }
    }

    private void set3DayCountdown(SpecialistQuickCommunicateModel commParam, Long questionId) {
        LocalDateTime currDate = LocalDateTime.now();
        SpecialistQuickQuestion question = (SpecialistQuickQuestion)this.quickQuestionService.getById(questionId);
        if (question != null) {
            if (Objects.equals(commParam.getType(), 1)) {
                question.setLastReplyTime(null);
                question.setAutoCloseTime(null);
                this.redisClient.del(new String[]{"auto_close_" + questionId});
            }
            if (Objects.equals(commParam.getType(), 2)) {
                long autoCloseCountdown = this.redisClient.get("auto_close_countdown") != null ? (Long)this.redisClient.get("auto_close_countdown") : AUTO_CLOSE_COUNTDOWN;
                this.redisClient.set("auto_close_" + questionId, (Object)"1", autoCloseCountdown);
                question.setLastReplyTime(currDate);
                question.setAutoCloseTime(currDate.plusSeconds(autoCloseCountdown));
            }
            this.quickQuestionService.updateById(question);
            if (Objects.equals(commParam.getType(), 1)) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(SpecialistQuickQuestion::getId, (Object)question.getId())).set(SpecialistQuickQuestion::getLastReplyTime, null)).set(SpecialistQuickQuestion::getAutoCloseTime, null);
                this.quickQuestionService.update((Wrapper)wrapper);
            }
        }
    }

    @Override
    public List<SpecialistQuickCommunicate> getByIds(String ids) {
        List idList = Arrays.stream(ids.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            return ((SpecialistQuickCommunicateMapper)this.baseMapper).selectBatchIds(idList);
        }
        return null;
    }

    public SpecialistQuestionRecord isExpertAndCanReplyQuestion(SpecialistUser user, Long questionId) {
        LambdaQueryWrapper qrWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qrWrapper.eq(SpecialistQuestionRecord::getQuestionId, (Object)questionId)).eq(SpecialistQuestionRecord::getIsHistory, (Object)Boolean.FALSE)).eq(SpecialistQuestionRecord::getIsValid, (Object)Boolean.TRUE)).last("LIMIT 1");
        SpecialistQuestionRecord currentQuestionExpert = (SpecialistQuestionRecord)this.questionRecordService.getOne((Wrapper)qrWrapper);
        if (currentQuestionExpert == null) {
            throw new ServiceException("\u6b64\u95ee\u9898\u672a\u6307\u5b9a\u4efb\u4f55\u56de\u7b54\u4e13\u5bb6\uff01");
        }
        if (user == null || user.getIsSpecialist().booleanValue()) {
            Long doReplyExpertId = null;
            doReplyExpertId = user == null ? SpecialistConstants.SYS_SPECIALIST_ID : user.getSpecialistId();
            Long currentQuestionExpertId = currentQuestionExpert.getReceiveSpecialistId();
            boolean receiveExpert = Objects.equals(doReplyExpertId, currentQuestionExpertId);
            boolean systemExpert = Objects.equals(doReplyExpertId, SpecialistConstants.SYS_SPECIALIST_ID);
            if (receiveExpert || systemExpert) {
                return currentQuestionExpert;
            }
            qrWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qrWrapper.eq(SpecialistQuestionRecord::getQuestionId, (Object)questionId)).eq(SpecialistQuestionRecord::getIsHistory, (Object)Boolean.TRUE)).eq(SpecialistQuestionRecord::getIsValid, (Object)Boolean.TRUE);
            List historyReceiveExpertList = this.questionRecordService.list((Wrapper)qrWrapper);
            List historyReceiveExpertIdList = historyReceiveExpertList.stream().map(SpecialistQuestionRecord::getReceiveSpecialistId).collect(Collectors.toList());
            boolean isHistory = historyReceiveExpertIdList.contains(doReplyExpertId);
            if (isHistory) {
                throw new ServiceException("\u95ee\u9898\u5df2\u79fb\u4ea4\uff0c\u6b64\u4e13\u5bb6\u4e0d\u80fd\u518d\u4f5c\u7b54\uff01");
            }
            throw new ServiceException("\u5f53\u524d\u4e13\u5bb6\u65e0\u6743\u56de\u590d\u6b64\u95ee\u9898\uff01");
        }
        return currentQuestionExpert;
    }

    public static boolean inclusionMatch(List<String> strList, String str) {
        if (CollUtil.isEmpty(strList) || CharSequenceUtil.isBlank((CharSequence)str)) {
            return Boolean.FALSE;
        }
        return strList.stream().anyMatch(s -> s.equalsIgnoreCase(str));
    }

    @Generated
    public SpecialistQuickCommunicateServiceImpl(ISpecialistQuestionRecordService questionRecordService, ISensitiveWordFilteringService filteringService, OssClientBean ossBean, RedisClient redisClient) {
        this.questionRecordService = questionRecordService;
        this.filteringService = filteringService;
        this.ossBean = ossBean;
        this.redisClient = redisClient;
    }
}

