/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.tt.impl;

import cn.smarthse.modules.sys.utils.HolidayUtils;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.tt.constants.SpecialistConstants;
import cn.smarthse.tt.dao.tt.SpecialistQuestionRecordMapper;
import cn.smarthse.tt.entity.SpecialistAnswerCount;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.enums.SpecialistExpertiseAreaEnum;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.service.sys.IQuestionTransferService;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistInfoVo;
import cn.smarthse.tt.vo.SpecialistQuestionCount;
import cn.smarthse.tt.vo.SpecialistQuestionRecordVo;
import com.aliyun.oss.ServiceException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SpecialistQuestionRecordServiceImpl
extends ServiceImpl<SpecialistQuestionRecordMapper, SpecialistQuestionRecord>
implements ISpecialistQuestionRecordService {
    @Autowired
    private ISpecialistInfoService specialistInfoService;
    @Autowired
    @Lazy
    private ISpecialistQuickQuestionService questionService;
    @Autowired
    @Lazy
    private IQuestionTransferService questionTransferService;
    @Autowired
    protected IdWorker idworker;

    @Override
    public List<SpecialistQuestionRecordVo> getTransferList(Long questionId) {
        List<SpecialistQuestionRecordVo> transferList = ((SpecialistQuestionRecordMapper)this.baseMapper).getTransferList(questionId);
        ArrayList<SpecialistQuestionRecordVo> list = new ArrayList<SpecialistQuestionRecordVo>();
        if (CollectionUtils.isNotEmpty(transferList)) {
            boolean onlyOne = true;
            SpecialistQuickQuestion question = (SpecialistQuickQuestion)this.questionService.getById(questionId);
            for (int i = 0; i < transferList.size(); ++i) {
                SpecialistQuestionRecordVo vo;
                SpecialistQuestionRecordVo recordVo = transferList.get(i);
                if (i == transferList.size() - 1) {
                    if (onlyOne && (Objects.equals(recordVo.getQuestionStatus(), 2) || Objects.equals(recordVo.getQuestionStatus(), 3))) {
                        onlyOne = false;
                        vo = new SpecialistQuestionRecordVo();
                        vo.setUpdateDate(question.getUpdateDate());
                        if (Objects.equals(recordVo.getQuestionStatus(), 2)) {
                            vo.setContent(Integer.valueOf(4));
                        } else {
                            vo.setContent(Integer.valueOf(5));
                        }
                        list.add(vo);
                    }
                    recordVo.setContent(Integer.valueOf(1));
                    list.add(recordVo);
                    vo = new SpecialistQuestionRecordVo();
                    BeanUtils.copyProperties((Object)recordVo, (Object)vo);
                    vo.setContent(Integer.valueOf(0));
                    vo.setUpdateDate(question.getCreateDate());
                    vo.setSpecialistName(null);
                    list.add(vo);
                    continue;
                }
                SpecialistQuestionRecordVo nextRecordVo = transferList.get(i + 1);
                if (onlyOne && (Objects.equals(recordVo.getQuestionStatus(), 2) || Objects.equals(recordVo.getQuestionStatus(), 3))) {
                    onlyOne = false;
                    vo = new SpecialistQuestionRecordVo();
                    vo.setUpdateDate(recordVo.getUpdateDate());
                    if (Objects.equals(recordVo.getQuestionStatus(), 2)) {
                        vo.setContent(Integer.valueOf(4));
                    } else {
                        vo.setContent(Integer.valueOf(5));
                    }
                    list.add(vo);
                    if (Objects.equals(nextRecordVo.getTransferType(), 2)) {
                        vo = new SpecialistQuestionRecordVo();
                        vo.setUpdateDate(recordVo.getUpdateDate());
                        vo.setContent(Integer.valueOf(2));
                        recordVo.setContent(Integer.valueOf(1));
                        list.add(recordVo);
                        continue;
                    }
                    if (!Objects.equals(nextRecordVo.getTransferType(), 1)) continue;
                    recordVo.setContent(Integer.valueOf(3));
                    recordVo.setReasonType(nextRecordVo.getReasonType());
                    recordVo.setReason(nextRecordVo.getReason());
                    recordVo.setSpecialistFieldType(nextRecordVo.getSpecialistFieldType());
                    recordVo.setSpecialistFieldTypeStr(SpecialistExpertiseAreaEnum.getName((String)String.valueOf(nextRecordVo.getSpecialistFieldType())));
                    list.add(recordVo);
                    continue;
                }
                if (Objects.equals(nextRecordVo.getQuestionStatus(), 4)) {
                    recordVo.setContent(Integer.valueOf(1));
                    list.add(recordVo);
                    continue;
                }
                if (Objects.equals(nextRecordVo.getTransferType(), 2)) {
                    vo = new SpecialistQuestionRecordVo();
                    vo.setUpdateDate(recordVo.getUpdateDate());
                    vo.setContent(Integer.valueOf(2));
                    recordVo.setContent(Integer.valueOf(1));
                    list.add(recordVo);
                    list.add(vo);
                    continue;
                }
                if (!Objects.equals(nextRecordVo.getTransferType(), 1)) continue;
                recordVo.setContent(Integer.valueOf(3));
                recordVo.setReasonType(nextRecordVo.getReasonType());
                recordVo.setReason(nextRecordVo.getReason());
                recordVo.setSpecialistFieldType(nextRecordVo.getSpecialistFieldType());
                recordVo.setSpecialistFieldTypeStr(SpecialistExpertiseAreaEnum.getName((String)String.valueOf(nextRecordVo.getSpecialistFieldType())));
                list.add(recordVo);
            }
        }
        return list;
    }

    @Override
    public SpecialistQuestionRecord transferQuestion(SpecialistQuestionRecord record, Long userId) {
        SpecialistQuestionRecord latestRecord = ((SpecialistQuestionRecordMapper)this.baseMapper).getLatestRecord(record.getQuestionId());
        if (latestRecord != null) {
            if (userId != null && !Objects.equals(userId, latestRecord.getReceiveSpecialistId())) {
                throw new javax.smarthse.exception.ServiceException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u95ee\u9898");
            }
            if (record.getSpecialistFieldType() == null) {
                record.setSpecialistFieldType(latestRecord.getSpecialistFieldType());
            }
            if (Objects.equals(record.getTransferType(), 1)) {
                if (record.getReasonType() == null) {
                    throw new RuntimeException("\u79fb\u4ea4\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (record.getReasonType() == 1) {
                    record.setQuestionStatus(Integer.valueOf(6));
                } else if (record.getReasonType() == 2) {
                    record.setQuestionStatus(Integer.valueOf(7));
                }
            } else if (Objects.equals(record.getTransferType(), 2)) {
                record.setReasonType(Integer.valueOf(3));
                record.setQuestionStatus(Integer.valueOf(5));
            }
            ((SpecialistQuestionRecordMapper)this.baseMapper).setIsHistory(latestRecord.getId(), record, userId);
            if (record.getSpecialistFieldType() != null) {
                SpecialistQuickQuestion question = new SpecialistQuickQuestion();
                question.setId(record.getQuestionId());
                question.setType(record.getSpecialistFieldType());
                this.questionService.updateType(question);
            }
            SpecialistQuestionRecord questionRecord = new SpecialistQuestionRecord();
            questionRecord.setId(Long.valueOf(this.idworker.nextId()));
            questionRecord.setUpdateBy(userId);
            questionRecord.setUpdateDate(new Date());
            questionRecord.setQuestionId(record.getQuestionId());
            questionRecord.setTransferSpecialistId(latestRecord.getReceiveSpecialistId());
            questionRecord.setSpecialistFieldType(record.getSpecialistFieldType());
            questionRecord.setQuestionStatus(Integer.valueOf(4));
            ((SpecialistQuestionRecordMapper)this.baseMapper).insert(questionRecord);
            return questionRecord;
        }
        return null;
    }

    @Override
    public void setReceiveSpecialist(Long questionId, Date updateDate, Long receiveSpecialistId, Long userId) {
        SpecialistQuestionRecord record;
        SpecialistQuestionRecord latestRecord = ((SpecialistQuestionRecordMapper)this.baseMapper).getLatestRecord(questionId);
        if (latestRecord == null) {
            record = new SpecialistQuestionRecord();
            record.setId(Long.valueOf(this.idworker.nextId()));
            record.setQuestionId(questionId);
            SpecialistQuickQuestion question = (SpecialistQuickQuestion)this.questionService.getById(questionId);
            if (question != null) {
                record.setSpecialistFieldType(question.getType());
            }
            record.setReceiveSpecialistId(receiveSpecialistId);
            record.setIsHistory(Boolean.valueOf(false));
            record.setQuestionStatus(SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey());
            record.setCreateDate(new Date());
            record.setCreateBy(userId);
            if (!Objects.equals(receiveSpecialistId, SpecialistConstants.SYS_SPECIALIST_ID)) {
                this.setNoResponseTime(record, updateDate);
                this.questionTransferService.addMessage(record.getId().toString(), record.getNoResponseTime().getTime() - System.currentTimeMillis());
            }
            ((SpecialistQuestionRecordMapper)this.baseMapper).insert(record);
        } else {
            record = new SpecialistQuestionRecord();
            record.setReceiveSpecialistId(receiveSpecialistId);
            record.setQuestionId(questionId);
            record.setUpdateBy(userId);
            if (!Objects.equals(receiveSpecialistId, SpecialistConstants.SYS_SPECIALIST_ID)) {
                this.setNoResponseTime(record, updateDate);
                this.questionTransferService.addMessage(latestRecord.getId().toString(), record.getNoResponseTime().getTime() - System.currentTimeMillis());
            }
            ((SpecialistQuestionRecordMapper)this.baseMapper).setReceiveSpecialist(record);
        }
        this.questionService.sendSms(record.getReceiveSpecialistId());
    }

    @Override
    public SpecialistAnswerCount getAnswerProvinceCount(List<Long> questionIdList) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getAnswerProvinceCount(questionIdList);
    }

    @Override
    public List<SpecialistAnswerCount> getAnswerCityCount(List<Long> questionIdList) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getAnswerCityCount(questionIdList);
    }

    @Override
    public List<SpecialistQuestionCount> getQuestionProvinceCount(List<Long> questionIdList) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getQuestionProvinceCount(questionIdList);
    }

    @Override
    public List<SpecialistQuestionCount> getQuestionCityCount(List<Long> questionIdList) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getQuestionCityCount(questionIdList);
    }

    @Override
    public List<SpecialistQuestionCount> filteredProvinceCount(List<Long> questionId) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).filteredProvinceCount(questionId);
    }

    @Override
    public List<SpecialistQuestionCount> filteredCityCount(Long areaId, List<Long> questionId) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).filteredCityCount(areaId, questionId);
    }

    @Override
    public void setQuestionStatus(Long questionId, Long specialistId, Integer status) {
        ((SpecialistQuestionRecordMapper)this.baseMapper).setQuestionStatus(questionId, specialistId, status);
    }

    @Override
    public List<SpecialistInfoVo> getSpecialistInfos(Long questionId) {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getSpecialistInfos(questionId);
    }

    @Override
    public List<SpecialistQuestionRecord> getAllLatestRecords() {
        return ((SpecialistQuestionRecordMapper)this.baseMapper).getAllLatestRecords();
    }

    private void setNoResponseTime(SpecialistQuestionRecord record, Date updateDate) {
        LocalDateTime endTime;
        SpecialistInfo specialistInfo = (SpecialistInfo)this.specialistInfoService.getById(record.getReceiveSpecialistId());
        if (specialistInfo != null) {
            LocalDateTime now;
            endTime = null;
            LocalDateTime localDateTime = now = updateDate != null ? updateDate.toInstant().atZone(ZoneOffset.ofHours(8)).toLocalDateTime() : LocalDateTime.now();
            if (Objects.equals(specialistInfo.getType(), (byte)1)) {
                endTime = this.getEndTimeOfNoResponse(now, specialistInfo.getType());
            } else if (Objects.equals(specialistInfo.getType(), (byte)2)) {
                endTime = this.getEndTimeOfNoResponse(now, specialistInfo.getType());
            } else {
                throw new RuntimeException("\u4e13\u5bb6\u7c7b\u522btype\u4e0d\u6b63\u786e\u3002");
            }
            if (endTime == null) {
                throw new RuntimeException("\u5012\u8ba1\u65f6\u83b7\u53d6\u5f02\u5e38\u3002");
            }
        } else {
            throw new RuntimeException("\u6240\u5339\u914d\u7684\u4e13\u5bb6\u4e0d\u5b58\u5728\u3002");
        }
        record.setNoResponseTime(Date.from(endTime.atZone(ZoneOffset.ofHours(8)).toInstant()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocalDateTime getEndTimeOfNoResponse(LocalDateTime now, Byte type) {
        if (!HolidayUtils.isWeekday((LocalDate)now.toLocalDate()).booleanValue()) {
            if (type == 1) {
                LocalDateTime nextWorkday = now.with(this.nextWorkingDay());
                LocalDateTime secondWorkday = nextWorkday.with(this.nextWorkingDay());
                return secondWorkday.withHour(8).withMinute(30).withSecond(0).withNano(0);
            }
            if (type != 2) throw new javax.smarthse.exception.ServiceException("\u65e0\u6548\u7684\u4e13\u5bb6\u7c7b\u578b" + type);
            LocalDateTime nextWorkday = now.with(this.nextWorkingDay());
            LocalDateTime secondWorkday = nextWorkday.with(this.nextWorkingDay());
            LocalDateTime thirdWorkday = secondWorkday.with(this.nextWorkingDay());
            return thirdWorkday.withHour(8).withMinute(30).withSecond(0).withNano(0);
        }
        if (type == 1) {
            LocalDateTime secondWorkday = now.with(this.nextWorkingDay());
            return secondWorkday.withHour(now.getHour()).withMinute(now.getMinute()).withSecond(now.getSecond());
        }
        if (type != 2) throw new javax.smarthse.exception.ServiceException("\u65e0\u6548\u7684\u4e13\u5bb6\u7c7b\u578b" + type);
        LocalDateTime thirdWorkday = now.with(this.nextWorkingDay()).with(this.nextWorkingDay());
        return thirdWorkday.withHour(now.getHour()).withMinute(now.getMinute()).withSecond(now.getSecond());
    }

    private TemporalAdjuster nextWorkingDay() {
        return temporal -> {
            LocalDateTime dateTime = (LocalDateTime)temporal;
            LocalDateTime next = dateTime.plusDays(1L);
            while (!HolidayUtils.isWeekday((LocalDate)next.toLocalDate()).booleanValue()) {
                next = next.plusDays(1L);
            }
            return next;
        };
    }

    public Boolean isWeekday(LocalDate date) {
        if (HolidayUtils.holidayList.isEmpty() || HolidayUtils.supplementaryShiftList.isEmpty()) {
            throw new ServiceException("\u8282\u5047\u65e5\u6570\u636e\u52a0\u8f7d\u5f02\u5e38");
        }
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && !HolidayUtils.holidayList.contains((Object)date) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && HolidayUtils.supplementaryShiftList.contains((Object)date);
    }
}

