/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.tt.impl;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.tt.converter.SpecialistInfoConverter;
import cn.smarthse.tt.dao.tt.SpecialistInfoMapper;
import cn.smarthse.tt.dto.SpecialistInfoDto;
import cn.smarthse.tt.entity.SpecialistAnswerCount;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.SpecialistOperateRecord;
import cn.smarthse.tt.enums.SpecialistExpertiseAreaEnum;
import cn.smarthse.tt.enums.SpecialistJobTitleEnum;
import cn.smarthse.tt.framework.Constant;
import cn.smarthse.tt.model.SpecialistActiveParam;
import cn.smarthse.tt.model.SpecialistInfoModel;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import cn.smarthse.tt.service.tt.ISpecialistOperateRecordService;
import cn.smarthse.tt.vo.SpecialistActiveVo;
import cn.smarthse.tt.vo.SpecialistInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SpecialistInfoServiceImpl
extends ServiceImpl<SpecialistInfoMapper, SpecialistInfo>
implements ISpecialistInfoService {
    @Autowired
    protected IdWorker idworker;
    private final SpecialistInfoConverter specialistInfoConverter;
    @Autowired
    private RedisClient redisClient;
    private static final String CACHE_NAME = "SpecialistInfoServiceImpl";
    @Autowired
    private ISpecialistOperateRecordService operateRecordService;

    @Override
    public PageInfo<SpecialistInfoVo> getSpecialistInfoList(SpecialistInfoModel model) {
        PageHelper.startPage((int)model.getPage(), (int)model.getRows());
        return new PageInfo(((SpecialistInfoMapper)this.baseMapper).getSpecialistInfoList(model));
    }

    @Override
    public PageInfo<SpecialistInfoVo> getSpecialistInfoListToUser(SpecialistInfoModel model) {
        PageHelper.startPage((int)model.getPage(), (int)model.getRows());
        return new PageInfo(((SpecialistInfoMapper)this.baseMapper).getSpecialistInfoListToUser(model));
    }

    @Override
    public SpecialistInfoVo getSpecialistInfoById(Long id, Boolean isMaintenance) {
        return ((SpecialistInfoMapper)this.baseMapper).getSpecialistInfoById(id, isMaintenance);
    }

    @Override
    @Transactional
    public void saveSpecialistInfo(SpecialistInfoDto dto, Integer operatorType, Long userId) {
        SpecialistInfo info = this.specialistInfoConverter.dto2entity(dto);
        LocalDateTime now = LocalDateTime.now();
        if (info.getId() == null) {
            info.setCreateDate(now);
            info.setCreateBy(userId);
            info.setUpdateBy(userId);
            info.setUpdateDate(now);
            ((SpecialistInfoMapper)this.baseMapper).insert(info);
            this.addOperations(info, null, operatorType, 1, userId);
        } else {
            SpecialistInfo oldData = (SpecialistInfo)((SpecialistInfoMapper)this.baseMapper).selectById(info.getId());
            info.setUpdateBy(userId);
            info.setUpdateDate(now);
            ((SpecialistInfoMapper)this.baseMapper).updateById(info);
            this.addOperations(info, oldData, operatorType, 2, userId);
        }
    }

    @Override
    public void addOperations(SpecialistInfo newData, SpecialistInfo oldData, Integer operatorType, Integer type, Long userId) {
        ArrayList<SpecialistOperateRecord> recordList = new ArrayList<SpecialistOperateRecord>();
        SpecialistOperateRecord operateRecord = new SpecialistOperateRecord();
        operateRecord.setSpecialistId(newData.getId());
        operateRecord.setOperatorType(operatorType);
        operateRecord.setType(type);
        if (operateRecord.getType() == 1) {
            recordList.add(operateRecord);
        } else if (operateRecord.getType() == 2) {
            if (StringUtils.isNotBlank((CharSequence)newData.getFaceId()) && !newData.getFaceId().equals(oldData.getFaceId())) {
                recordList.add(this.setChangeContent("-", "\u5934\u50cf\u7f16\u8f91", operateRecord));
            }
            if (StringUtils.isNotBlank((CharSequence)newData.getCompanyName()) && !newData.getCompanyName().equals(oldData.getCompanyName())) {
                recordList.add(this.setChangeContent(oldData.getCompanyName(), newData.getCompanyName(), operateRecord));
            }
            if (StringUtils.isNotBlank((CharSequence)newData.getUserMobile()) && !newData.getUserMobile().equals(oldData.getUserMobile())) {
                recordList.add(this.setChangeContent(oldData.getUserMobile(), newData.getUserMobile(), operateRecord));
            }
            if (StringUtils.isNotBlank((CharSequence)newData.getJobTitle()) && !newData.getJobTitle().equals(oldData.getJobTitle())) {
                recordList.add(this.setChangeContent(oldData.getJobTitle(), newData.getJobTitle(), operateRecord));
            }
            if (newData.getType() != null && !newData.getType().equals(oldData.getType())) {
                recordList.add(this.setChangeContent(this.getTypeStr(oldData.getType()), this.getTypeStr(newData.getType()), operateRecord));
            }
            if (StringUtils.isNotBlank((CharSequence)newData.getExpertiseArea()) && !newData.getExpertiseArea().equals(oldData.getExpertiseArea())) {
                recordList.add(this.setChangeContent(this.getExpertiseArea(oldData.getExpertiseArea()), this.getExpertiseArea(newData.getExpertiseArea()), operateRecord));
            }
            if (StringUtils.isNotBlank((CharSequence)newData.getInfo()) && !newData.getInfo().equals(oldData.getInfo())) {
                recordList.add(this.setChangeContent(oldData.getInfo(), newData.getInfo(), operateRecord));
            }
            if (newData.getIsFallback() != null && !newData.getIsFallback().equals(oldData.getIsFallback())) {
                recordList.add(this.setChangeContent(this.getFallbackStr(oldData.getIsFallback()), this.getFallbackStr(newData.getIsFallback()), operateRecord));
            }
        } else if (operateRecord.getType() == 3) {
            recordList.add(this.setChangeContent(this.getEnterStr(newData.getIsEntering() == false), this.getEnterStr(newData.getIsEntering()), operateRecord));
        }
        this.operateRecordService.addOperateList(recordList, userId);
    }

    private String getExpertiseArea(String expertiseArea) {
        Object str = "";
        if (StringUtils.isNotBlank((CharSequence)expertiseArea)) {
            for (String job : expertiseArea.split(",")) {
                str = "".equals(str) ? SpecialistExpertiseAreaEnum.getName((String)job) : (String)str + "," + SpecialistExpertiseAreaEnum.getName((String)job);
            }
        }
        return str;
    }

    private String getJobTileStr(String jobTile) {
        Object str = "";
        if (StringUtils.isNotBlank((CharSequence)jobTile)) {
            for (String job : jobTile.split(",")) {
                str = "".equals(str) ? SpecialistJobTitleEnum.getName((String)job) : (String)str + "," + SpecialistJobTitleEnum.getName((String)job);
            }
        }
        return str;
    }

    private String getTypeStr(Byte type) {
        String str = "";
        if (type != null) {
            if (type == 1) {
                str = "\u7b2c\u4e00\u54cd\u5e94\u7b49\u7ea7";
            } else if (type == 2) {
                str = "\u7b2c\u4e8c\u54cd\u5e94\u7b49\u7ea7";
            }
        }
        return str;
    }

    private String getFallbackStr(Boolean isFallback) {
        String str = "";
        if (isFallback != null) {
            str = isFallback != false ? "\u662f\u515c\u5e95\u4e13\u5bb6" : "\u975e\u515c\u5e95\u4e13\u5bb6";
        }
        return str;
    }

    public SpecialistOperateRecord setChangeContent(String changeBefore, String changeAfter, SpecialistOperateRecord original) {
        SpecialistOperateRecord operateRecord = new SpecialistOperateRecord();
        BeanUtils.copyProperties((Object)original, (Object)operateRecord);
        operateRecord.setChangeBefore(changeBefore);
        operateRecord.setChangeAfter(changeAfter);
        return operateRecord;
    }

    public String getEnterStr(Boolean b) {
        if (b != null && b.booleanValue()) {
            return "\u5728\u5e93";
        }
        return "\u51fa\u5e93";
    }

    @Override
    public SpecialistInfo getSpecialistInfoByPhone(String phone) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(SpecialistInfo::getUserMobile, (Object)phone)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("LIMIT 1");
        return (SpecialistInfo)((SpecialistInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<CompanySuperviseModel> getCacheAllCompanyList() {
        return null;
    }

    @Override
    public SpecialistInfoVo getLatestSpecialistInfo(Long questionId) {
        return ((SpecialistInfoMapper)this.baseMapper).getLatestSpecialistInfo(questionId);
    }

    @Override
    @Transactional
    public void saveOrUpdateSpecialistInfos(ArrayList<SpecialistInfo> list, Integer operatorType, Long userId) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List userMobiles = list.stream().map(SpecialistInfo::getUserMobile).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().in(SpecialistInfo::getUserMobile, userMobiles)).eq(BaseEntity::getIsValid, (Object)true);
        List existingSpecialists = ((SpecialistInfoMapper)this.baseMapper).selectList((Wrapper)wrapper);
        Map existingMap = existingSpecialists.stream().collect(Collectors.toMap(SpecialistInfo::getUserMobile, Function.identity()));
        ArrayList<SpecialistInfo> toUpdate = new ArrayList<SpecialistInfo>();
        ArrayList<SpecialistInfo> toInsert = new ArrayList<SpecialistInfo>();
        for (SpecialistInfo specialistInfo : list) {
            if (existingMap.containsKey(specialistInfo.getUserMobile())) {
                SpecialistInfo existingSpecialist = (SpecialistInfo)existingMap.get(specialistInfo.getUserMobile());
                specialistInfo.setId(existingSpecialist.getId());
                toUpdate.add(specialistInfo);
                continue;
            }
            specialistInfo.setId(Long.valueOf(this.idworker.nextId()));
            specialistInfo.setCreateBy(userId);
            specialistInfo.setCreateDate(LocalDateTime.now());
            toInsert.add(specialistInfo);
        }
        if (!toUpdate.isEmpty()) {
            this.updateBatchById(toUpdate);
            for (SpecialistInfo newInfo : toUpdate) {
                SpecialistInfo oldInfo = (SpecialistInfo)existingMap.get(newInfo.getUserMobile());
                this.addOperations(newInfo, oldInfo, operatorType, 2, userId);
            }
        }
        if (!toInsert.isEmpty()) {
            this.saveBatch(toInsert);
            for (SpecialistInfo specialistInfo : toInsert) {
                this.addOperations(specialistInfo, null, operatorType, 1, userId);
            }
        }
    }

    @Override
    public SpecialistAnswerCount getProvinceCount(Boolean specialistType) {
        return ((SpecialistInfoMapper)this.baseMapper).getProvinceCount(specialistType);
    }

    @Override
    public List<SpecialistAnswerCount> getCityCount(Boolean specialistType) {
        return ((SpecialistInfoMapper)this.baseMapper).getCityCount(specialistType);
    }

    @Override
    public PageInfo<SpecialistActiveVo> specialistActive(SpecialistActiveParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((SpecialistInfoMapper)this.baseMapper).specialistActive(param));
    }

    @Override
    public SpecialistInfo getFallBackById(Long id) {
        return ((SpecialistInfoMapper)this.baseMapper).getFallBackById(id);
    }

    @Generated
    public SpecialistInfoServiceImpl(SpecialistInfoConverter specialistInfoConverter) {
        this.specialistInfoConverter = specialistInfoConverter;
    }
}

