/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.tt.impl;

import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.tt.dao.tt.ReplyTemplateMapper;
import cn.smarthse.tt.entity.ReplyTemplate;
import cn.smarthse.tt.entity.SpecialistQuickCommunicate;
import cn.smarthse.tt.model.ReplyTemplateModel;
import cn.smarthse.tt.service.tt.IReplyTemplateService;
import cn.smarthse.tt.service.tt.ISpecialistQuickCommunicateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReplyTemplateServiceImpl
extends ServiceImpl<ReplyTemplateMapper, ReplyTemplate>
implements IReplyTemplateService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private ISpecialistQuickCommunicateService communicateService;

    @Override
    public List<ReplyTemplate> getPageList(Long specialistId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReplyTemplate.class).select(new SFunction[]{ReplyTemplate::getId, ReplyTemplate::getSpecialistId, ReplyTemplate::getQuestionId, ReplyTemplate::getCommunicateId, ReplyTemplate::getContent, ReplyTemplate::getUpdateDate}).eq(ReplyTemplate::getSpecialistId, (Object)specialistId)).eq(ReplyTemplate::getIsValid, (Object)true)).orderByDesc(ReplyTemplate::getUpdateDate);
        return ((ReplyTemplateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void addTemplateList(ReplyTemplateModel model) {
        List<SpecialistQuickCommunicate> list = this.communicateService.getByIds(model.getReplyIds());
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList replyTemplateList = new ArrayList();
            list.forEach(e -> {
                Date date = new Date();
                if (e.getType() == 2) {
                    ReplyTemplate template = new ReplyTemplate();
                    template.setId(Long.valueOf(this.idworker.nextId()));
                    template.setSpecialistId(model.getSpecialistId());
                    template.setQuestionId(e.getQuestionId());
                    template.setCommunicateId(e.getId());
                    template.setContent(e.getContent());
                    template.setUpdateDate(date);
                    replyTemplateList.add(template);
                }
            });
            this.saveBatch(replyTemplateList);
        }
    }

    @Override
    public void deleteTemplateList(ReplyTemplateModel model) {
        List idList = Arrays.stream(model.getReplyIds().split(",")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ReplyTemplate.class).set(ReplyTemplate::getIsValid, (Object)false)).eq(ReplyTemplate::getSpecialistId, (Object)model.getSpecialistId())).in(ReplyTemplate::getCommunicateId, idList);
            this.update((Wrapper)updateWrapper);
        }
    }
}

