/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.service.sys.impl;

import cn.smarthse.tt.constants.SpecialistConstants;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.enums.SpecialistQuestionStatusEnum;
import cn.smarthse.tt.service.sys.IQuestionTransferService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;

@Service
public class QuestionTransferServiceImpl
implements IQuestionTransferService {
    private final String transferQueueName = "transferQueue";
    @Autowired
    private RedissonClient redissonClient;
    private RBlockingQueue<String> blockingQueue;
    private RDelayedQueue<String> delayedQueue;
    @Autowired
    private ISpecialistQuestionRecordService questionRecordService;
    @Autowired
    private ISpecialistQuickQuestionService questionService;
    @Autowired
    private DataSourceTransactionManager transactionManager;
    private volatile boolean running = true;

    @PostConstruct
    public void init() {
        this.blockingQueue = this.redissonClient.getBlockingQueue("transferQueue");
        this.delayedQueue = this.redissonClient.getDelayedQueue(this.blockingQueue);
        Executors.newSingleThreadExecutor().submit(this::processMessages);
    }

    @PreDestroy
    public void shutdown() {
        this.running = false;
        if (this.delayedQueue != null) {
            this.delayedQueue.destroy();
        }
    }

    @Override
    public void addMessage(String message, long delay) {
        this.delayedQueue.offer((Object)message, delay, TimeUnit.MILLISECONDS);
    }

    public void processMessages() {
        while (this.running) {
            try {
                SpecialistQuickQuestion question;
                String take = (String)this.blockingQueue.take();
                if (take == null) {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                SpecialistQuestionRecord record = (SpecialistQuestionRecord)this.questionRecordService.getById(Long.valueOf(take));
                if (record == null || !record.getIsValid().booleanValue() || record.getIsHistory().booleanValue() || !Objects.equals(SpecialistQuestionStatusEnum.WAIT_RESPONSE.getKey(), record.getQuestionStatus()) || record.getReceiveSpecialistId() == null || record.getReceiveSpecialistId().equals(SpecialistConstants.SYS_SPECIALIST_ID) || (question = (SpecialistQuickQuestion)this.questionService.getById(record.getQuestionId())) == null) continue;
                SpecialistQuestionRecord newRecord = new SpecialistQuestionRecord();
                newRecord.setQuestionId(record.getQuestionId());
                newRecord.setTransferType(Integer.valueOf(2));
                newRecord.setReasonType(Integer.valueOf(3));
                newRecord.setSpecialistFieldType(record.getSpecialistFieldType());
                newRecord.setTransferSpecialistId(record.getReceiveSpecialistId());
                this.questionRecordService.transferQuestion(newRecord, null);
                Long expertId = this.questionService.transferAndMatchExpertId(newRecord);
                this.questionRecordService.setReceiveSpecialist(question.getId(), null, expertId, null);
            }
            catch (RedisException e) {
                System.err.println("Redisson\u8fde\u63a5\u5931\u8d25\u6216\u5173\u95ed\uff1a" + e.getMessage());
                break;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

