/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.provider.supervise;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.tt.dto.SpecialistInfoDto;
import cn.smarthse.tt.entity.ReplyTemplate;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.SpecialistParam;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.SpecialistQuickCommunicate;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.enums.SpecialistExpertiseAreaEnum;
import cn.smarthse.tt.framework.Constant;
import cn.smarthse.tt.model.ReplyTemplateModel;
import cn.smarthse.tt.model.SpecialistActiveParam;
import cn.smarthse.tt.model.SpecialistCountModel;
import cn.smarthse.tt.model.SpecialistInfoModel;
import cn.smarthse.tt.model.SpecialistModel;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.provider.supervise.ISpecialistInfoProviderToSupervise;
import cn.smarthse.tt.service.sys.ISpecialistUserService;
import cn.smarthse.tt.service.tt.IReplyTemplateService;
import cn.smarthse.tt.service.tt.ISpecialistAnswerCountService;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import cn.smarthse.tt.service.tt.ISpecialistOperateRecordService;
import cn.smarthse.tt.service.tt.ISpecialistParamService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickCommunicateService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistActiveVo;
import cn.smarthse.tt.vo.SpecialistCountDetailVo;
import cn.smarthse.tt.vo.SpecialistCountVo;
import cn.smarthse.tt.vo.SpecialistInfoVo;
import cn.smarthse.tt.vo.SpecialistOperateRecordVo;
import cn.smarthse.tt.vo.SpecialistQuestionRecordVo;
import cn.smarthse.tt.vo.SpecialistQuickQuestionVo;
import cn.smarthse.util.common.excel.ExcelUtils;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.RowModel2;
import cn.smarthse.util.common.excel.model.SheetModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SpecialistInfoProviderToSupervise
implements ISpecialistInfoProviderToSupervise {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecialistInfoProviderToSupervise.class);
    @Autowired
    protected IdWorker idworker;
    private static final String serviceDir = "outurl/specialistFace";
    @Value(value="${ossclient.oss_local}")
    private String localDir;
    private final ISpecialistInfoService specialistInfoService;
    private final ISpecialistOperateRecordService operateRecordService;
    private final ISpecialistAnswerCountService answerCountService;
    private final ISpecialistQuestionRecordService questionRecordService;
    private final IReplyTemplateService replyTemplateService;
    private final ISpecialistParamService specialistParamService;
    private final ISpecialistUserService specialistUserService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final OssClientBean ossClientBean;
    private final ISpecialistQuickQuestionService questionService;
    private final ISpecialistQuickCommunicateService quickCommunicateService;

    public SpecialistInfoVo getSpecialistInfoById(Long id, Boolean isMaintenance) {
        return this.specialistInfoService.getSpecialistInfoById(id, isMaintenance);
    }

    public PageInfo<SpecialistInfoVo> getSpecialistInfoList(SpecialistInfoModel model) {
        return this.specialistInfoService.getSpecialistInfoList(model);
    }

    public void saveSpecialistInfo(SpecialistInfoDto dto, Integer operatorType, Long userId) {
        this.specialistInfoService.saveSpecialistInfo(dto, operatorType, userId);
    }

    @Transactional
    public ResponseData<String> editEnteringStatus(Long id, Long userId) {
        String msg;
        SpecialistInfo specialistInfo = (SpecialistInfo)this.specialistInfoService.getById(id);
        if (specialistInfo == null) {
            return ResponseData.fail((String)"\u4f20\u5165\u4fe1\u606f\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u4e13\u5bb6");
        }
        if (specialistInfo.getIsFallback().booleanValue()) {
            return ResponseData.fail((String)"\u8be5\u4e13\u5bb6\u4e3a\u515c\u5e95\u4e13\u5bb6\uff0c\u7981\u6b62\u51fa\u5e93\uff0c\u82e5\u8981\u51fa\u5e93\u8bf7\u8bbe\u7f6e\u540c\u5730\u5e02\u53e6\u4e00\u4e2a\u515c\u5e95\u4e13\u5bb6\u540e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\uff01");
        }
        Boolean isEntering = specialistInfo.getIsEntering();
        if (!isEntering.booleanValue()) {
            specialistInfo.setIsEntering(Boolean.valueOf(true));
            msg = "\u4e13\u5bb6\u5df2\u5f55\u5165\u4e13\u5bb6\u5e93";
        } else {
            specialistInfo.setIsEntering(Boolean.valueOf(false));
            msg = "\u4e13\u5bb6\u5df2\u79fb\u51fa\u4e13\u5bb6\u5e93";
        }
        specialistInfo.setUpdateDate(LocalDateTime.now());
        specialistInfo.setUpdateBy(userId);
        this.specialistInfoService.updateById(specialistInfo);
        this.specialistInfoService.addOperations(specialistInfo, null, 2, 3, userId);
        return ResponseData.success((String)msg);
    }

    public SpecialistCountVo getResponsivityData(SpecialistCountModel model) {
        SpecialistCountVo vo = this.answerCountService.getResponsivityData(model);
        return vo;
    }

    public JqGridData<SpecialistCountVo> getResponsivityListData(SpecialistCountModel model) {
        PageInfo<SpecialistCountVo> page = this.answerCountService.getResponsivityListData(model);
        return new JqGridData(page, (JqGridParam)model);
    }

    public JqGridData<SpecialistCountDetailVo> getResponsivityDetail(SpecialistCountModel model) {
        PageInfo<SpecialistCountDetailVo> pageInfo = this.answerCountService.getResponsivityDetail(model);
        return new JqGridData(pageInfo, (JqGridParam)model);
    }

    public PageInfo<SpecialistOperateRecordVo> getOperateList(Long specialistId, JqGridParam page) {
        return this.operateRecordService.getPageList(specialistId, page);
    }

    public List<SpecialistQuestionRecordVo> getTransferList(Long questionId) {
        return this.questionRecordService.getTransferList(questionId);
    }

    public void saveSysParam(SpecialistModel model, Long userId) {
        this.specialistParamService.saveSysParam(model, userId);
    }

    public List<SpecialistParam> sysParamList() {
        return this.specialistParamService.list();
    }

    public PageInfo<SpecialistQuickQuestionVo> getQuestionListBySearch(JqGridParam pageParam, SpecialistQuickQuestionModel queParam) {
        return this.questionService.getQuestionListBySearch(pageParam, queParam);
    }

    public SpecialistQuickQuestionVo getQuestionInfo(Long id, Long specialistId) {
        return this.questionService.getQuestionInfo(id, specialistId);
    }

    public List<ReplyTemplate> getPageList(Long specialistId) {
        return this.replyTemplateService.getPageList(specialistId);
    }

    public void addTemplateList(ReplyTemplateModel model) {
        this.replyTemplateService.addTemplateList(model);
    }

    public void deleteTemplateList(ReplyTemplateModel model) {
        this.replyTemplateService.deleteTemplateList(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseData<String> importSpecialist(SysFileModel file, Integer operatorType, Long userId) throws IOException {
        ResponseData rst = new ResponseData();
        String ossUrl = this.ossClientBean.getUrl(file.getOssUrl());
        try (HttpResponse execute = HttpUtil.createGet((String)ossUrl).execute();
             InputStream inputStream = execute.bodyStream();
             InputStream inputStream2 = execute.bodyStream();){
            String fileExtension = FilenameUtils.getExtension((String)file.getFileName());
            if (!"xls".equalsIgnoreCase(fileExtension)) {
                ResponseData responseData = ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f");
                return responseData;
            }
            ExcelModel excelModel = ExcelUtils.parseXls((InputStream)inputStream, (int[])new int[]{11});
            Map imgMap = ExcelUtils.arrangeXlsImg((InputStream)inputStream2, (int)1);
            SheetModel sheetModel = (SheetModel)excelModel.getSheets().get(0);
            List rows = sheetModel.getRows2();
            ArrayList<SpecialistInfo> list = new ArrayList<SpecialistInfo>();
            ArrayList<Long> index = new ArrayList<Long>();
            for (int i = 1; i < rows.size(); ++i) {
                RowModel specialist = ((RowModel2)rows.get(i)).getCol();
                if (imgMap != null && !imgMap.isEmpty()) {
                    HSSFShape shape;
                    String fileName = (String)specialist.get(2) + "\u4e13\u5bb6\u7167\u7247";
                    List shapes = (List)imgMap.get(i + 1);
                    if (shapes != null && (shape = (HSSFShape)shapes.get(0)) != null && shape instanceof HSSFPicture) {
                        block38: {
                            HSSFPicture pic = (HSSFPicture)shape;
                            HSSFPictureData pictureData = pic.getPictureData();
                            String suffix = "." + pictureData.suggestFileExtension();
                            File tempFile = null;
                            SysFileModel fileModel = null;
                            try {
                                tempFile = File.createTempFile(fileName, suffix);
                                byte[] imgData = pic.getPictureData().getData();
                                File outputFile = this.byteToFile(imgData, this.localDir, tempFile.getName());
                                String uploadDir = this.ossClientBean.OSSPutObject(tempFile.getName(), outputFile, fileName + suffix, serviceDir, null);
                                fileModel = this.createAndAddSysFileModel(tempFile.getName(), outputFile, uploadDir, userId);
                                outputFile.delete();
                                if (tempFile == null) break block38;
                                if (!tempFile.exists()) break;
                                tempFile.delete();
                            }
                            catch (Exception e) {
                                ResponseData responseData;
                                block40: {
                                    log.error("\u56fe\u7247\u5bfc\u5165\u4e0a\u4f20\u95ee\u9898\uff1a" + e.getMessage());
                                    responseData = ResponseData.fail((String)"\u56fe\u7247\u5bfc\u5165\u4e0a\u4f20\u51fa\u73b0\u95ee\u9898");
                                    if (inputStream2 == null) break block40;
                                    inputStream2.close();
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (execute == null) return responseData;
                                execute.close();
                                return responseData;
                            }
                            finally {
                                if (tempFile != null && tempFile.exists()) {
                                    tempFile.delete();
                                }
                            }
                        }
                    }
                }
                SpecialistInfo info = this.RowModel2SpecialistInfo(specialist, userId, index);
                list.add(info);
            }
        }
    }

    public SpecialistInfoVo getLatestSpecialistInfo(Long questionId) {
        return this.specialistInfoService.getLatestSpecialistInfo(questionId);
    }

    @Transactional
    public void delSpecialistInfo(Long specialistId) {
        List operateRecordVoList;
        JqGridParam param = new JqGridParam();
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        List<ReplyTemplate> templateList = this.replyTemplateService.getPageList(specialistId);
        if (templateList != null && !templateList.isEmpty()) {
            List templateIds = templateList.stream().map(ReplyTemplate::getId).collect(Collectors.toList());
            this.replyTemplateService.removeByIds(templateIds);
        }
        if ((operateRecordVoList = this.operateRecordService.getPageList(specialistId, param).getList()) != null && !operateRecordVoList.isEmpty()) {
            List operateRecordIds = operateRecordVoList.stream().map(SpecialistOperateRecordVo::getId).collect(Collectors.toList());
            this.operateRecordService.removeByIds(operateRecordIds);
        }
        QueryWrapper questionRecordWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)questionRecordWrapper.lambda().eq(SpecialistQuestionRecord::getReceiveSpecialistId, (Object)specialistId)).or()).eq(SpecialistQuestionRecord::getTransferSpecialistId, (Object)specialistId);
        List questionRecords = this.questionRecordService.list((Wrapper)questionRecordWrapper);
        if (questionRecords != null && !questionRecords.isEmpty()) {
            List questionRecordIds = questionRecords.stream().map(SpecialistQuestionRecord::getId).collect(Collectors.toList());
            this.questionRecordService.removeByIds(questionRecordIds);
            List questionIds = questionRecords.stream().map(SpecialistQuestionRecord::getQuestionId).collect(Collectors.toList());
            if (questionIds != null && !questionIds.isEmpty()) {
                this.questionService.removeByIds(questionIds);
                QueryWrapper communicateWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)communicateWrapper.lambda().eq(SpecialistQuickCommunicate::getSpecialistId, (Object)specialistId)).or()).in(SpecialistQuickCommunicate::getQuestionId, questionIds);
                List quickCommunicateList = this.quickCommunicateService.list((Wrapper)communicateWrapper);
                if (quickCommunicateList != null && !quickCommunicateList.isEmpty()) {
                    List quickCommunicateIds = quickCommunicateList.stream().map(SpecialistQuickCommunicate::getId).collect(Collectors.toList());
                    this.quickCommunicateService.removeByIds(quickCommunicateIds);
                }
            }
        }
        this.specialistInfoService.removeById(specialistId);
        LambdaQueryWrapper userWrapper = Wrappers.lambdaQuery(SpecialistUser.class);
        ((LambdaQueryWrapper)userWrapper.eq(SpecialistUser::getSpecialistId, (Object)specialistId)).eq(BaseEntity::getIsValid, (Object)Constant.TRUE);
        SpecialistUser specialistUser = (SpecialistUser)this.specialistUserService.list((Wrapper)userWrapper).get(0);
        this.specialistUserService.removeById(specialistUser);
    }

    public PageInfo<SpecialistActiveVo> specialistActive(SpecialistActiveParam param) {
        PageInfo<SpecialistActiveVo> page = this.specialistInfoService.specialistActive(param);
        return page;
    }

    @Transactional
    public ResponseData<String> editIsvalidStatus(Long id, Long userId) {
        String msg;
        SpecialistInfo specialistInfo = (SpecialistInfo)this.specialistInfoService.getById(id);
        if (specialistInfo == null) {
            return ResponseData.fail((String)"\u4f20\u5165\u4fe1\u606f\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u4e13\u5bb6");
        }
        Boolean isValid = specialistInfo.getIsValid();
        if (!isValid.booleanValue()) {
            specialistInfo.setIsValid(Boolean.valueOf(true));
            msg = "\u4e13\u5bb6\u5df2\u53d6\u6d88\u9690\u85cf";
        } else {
            specialistInfo.setIsValid(Boolean.valueOf(false));
            msg = "\u4e13\u5bb6\u5df2\u9690\u85cf";
        }
        specialistInfo.setUpdateDate(LocalDateTime.now());
        specialistInfo.setUpdateBy(userId);
        this.specialistInfoService.updateById(specialistInfo);
        return ResponseData.success((String)msg);
    }

    @Transactional
    public ResponseData<String> editFallbackStatus(Long id, Long userId) {
        SpecialistInfo oldData = (SpecialistInfo)this.specialistInfoService.getById(id);
        if (oldData == null) {
            return ResponseData.fail((String)"\u4f20\u5165\u4fe1\u606f\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u4e13\u5bb6");
        }
        if (Objects.equals(oldData.getType(), (byte)2)) {
            return ResponseData.fail((String)"\u7b2c\u4e8c\u54cd\u5e94\u4e13\u5bb6\u65e0\u9700\u8bbe\u7f6e\u515c\u5e95\u4e13\u5bb6");
        }
        SpecialistInfo oldFallbackDB = this.specialistInfoService.getFallBackById(id);
        if (oldFallbackDB != null && Objects.equals(oldData.getId(), oldFallbackDB.getId())) {
            return ResponseData.fail((String)"\u5f53\u524d\u4e13\u5bb6\u4e3a\u515c\u5e95\u4e13\u5bb6\uff0c\u65e0\u9700\u53d8\u66f4");
        }
        SpecialistInfo newData = new SpecialistInfo();
        newData.setId(oldData.getId());
        newData.setIsFallback(Boolean.valueOf(true));
        newData.setUpdateDate(LocalDateTime.now());
        newData.setUpdateBy(userId);
        if (oldFallbackDB != null) {
            SpecialistInfo oldFallback = new SpecialistInfo();
            oldFallback.setId(oldFallbackDB.getId());
            oldFallback.setIsFallback(Boolean.valueOf(false));
            oldFallback.setUpdateDate(LocalDateTime.now());
            oldFallback.setUpdateBy(userId);
            this.specialistInfoService.updateById(oldFallback);
            this.specialistInfoService.addOperations(oldFallback, oldFallbackDB, 2, 2, userId);
        }
        this.specialistInfoService.updateById(newData);
        this.specialistInfoService.addOperations(newData, oldData, 2, 2, userId);
        return ResponseData.success();
    }

    private SpecialistInfo RowModel2SpecialistInfo(RowModel specialist, Long userId, List<Long> index) {
        SpecialistInfo info = new SpecialistInfo();
        block11: for (int i = 1; i < specialist.size(); ++i) {
            switch (i) {
                case 1: {
                    info.setFaceId((String)specialist.get(i));
                    continue block11;
                }
                case 2: {
                    info.setFullname((String)specialist.get(i));
                    continue block11;
                }
                case 3: {
                    String phone = (String)specialist.get(i);
                    if (this.isValidPhoneNumber(phone)) {
                        info.setUserMobile((String)specialist.get(i));
                        continue block11;
                    }
                    index.add(Long.valueOf((String)specialist.get(0)));
                    continue block11;
                }
                case 4: {
                    info.setCompanyName((String)specialist.get(i));
                    continue block11;
                }
                case 5: {
                    String expertiseAreaStr = (String)specialist.get(i);
                    info.setExpertiseArea(this.expertiseAreaStr2ExpertiseArea(expertiseAreaStr));
                    continue block11;
                }
                case 6: {
                    info.setJobTitle((String)specialist.get(i));
                    continue block11;
                }
                case 7: {
                    String typeStr = (String)specialist.get(i);
                    info.setType(this.typeStr2Type(typeStr));
                    continue block11;
                }
                case 8: {
                    String areaAddress;
                    String areaName = areaAddress = (String)specialist.get(i);
                    areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)"");
                    areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)"");
                    areaName = StringUtils.replace((String)areaName, (String)">", (String)"");
                    info.setAreaAddress(areaName);
                    AreaModel area = this.sysAreaProvideService.getAreaByName(areaAddress);
                    if (area == null) continue block11;
                    info.setAreaId(area.getId());
                    continue block11;
                }
                case 9: {
                    info.setInfo((String)specialist.get(i));
                    continue block11;
                }
            }
        }
        LocalDateTime now = LocalDateTime.now();
        info.setUpdateDate(now);
        info.setUpdateBy(userId);
        info.setIsEntering(Boolean.valueOf(true));
        return info;
    }

    private String expertiseAreaStr2ExpertiseArea(String expertiseAreaStr) {
        if (expertiseAreaStr == null || expertiseAreaStr.isEmpty()) {
            return "";
        }
        String[] split = expertiseAreaStr.contains("/") ? expertiseAreaStr.split("/") : (expertiseAreaStr.contains("\u3001") ? expertiseAreaStr.split("\u3001") : new String[]{expertiseAreaStr.trim()});
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            String code = SpecialistExpertiseAreaEnum.getCode((String)s.trim());
            sb.append(code);
        }
        return sb.toString();
    }

    private Byte typeStr2Type(String typeStr) {
        if (typeStr.contains("\u4e8c\u7ea7")) {
            return (byte)2;
        }
        if (typeStr.contains("\u4e00\u7ea7")) {
            return (byte)1;
        }
        return (byte)0;
    }

    public File byteToFile(byte[] bytes, String path, String name) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        File file = new File(path + "\\" + name);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        bout.write(bytes);
        return file;
    }

    public SysFileModel createAndAddSysFileModel(String fileName, File outputFile, String uploadDir, Long userId) throws IOException {
        SysFileModel fileModel = new SysFileModel();
        fileModel.setFileName(fileName);
        fileModel.setResource(Integer.valueOf(FileResourceEnum.TOWNSHIP_MANAGE.getValue()));
        fileModel.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)outputFile)));
        fileModel.setFileExt(fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "");
        fileModel.setFileHash("" + FileUtils.checksumCRC32((File)outputFile));
        fileModel.setOssUrl(uploadDir);
        fileModel.setDescription("");
        fileModel = this.sysFileProvideService.addSysFile(fileModel, userId);
        return fileModel;
    }

    public boolean isValidPhoneNumber(String phoneNumber) {
        String regex = "^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    @Generated
    public SpecialistInfoProviderToSupervise(ISpecialistInfoService specialistInfoService, ISpecialistOperateRecordService operateRecordService, ISpecialistAnswerCountService answerCountService, ISpecialistQuestionRecordService questionRecordService, IReplyTemplateService replyTemplateService, ISpecialistParamService specialistParamService, ISpecialistUserService specialistUserService, OssClientBean ossClientBean, ISpecialistQuickQuestionService questionService, ISpecialistQuickCommunicateService quickCommunicateService) {
        this.specialistInfoService = specialistInfoService;
        this.operateRecordService = operateRecordService;
        this.answerCountService = answerCountService;
        this.questionRecordService = questionRecordService;
        this.replyTemplateService = replyTemplateService;
        this.specialistParamService = specialistParamService;
        this.specialistUserService = specialistUserService;
        this.ossClientBean = ossClientBean;
        this.questionService = questionService;
        this.quickCommunicateService = quickCommunicateService;
    }

    private /* synthetic */ boolean lambda$importSpecialist$0(Long i) {
        return !this.isValidPhoneNumber(String.valueOf(i));
    }
}

