/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.manage.zlb;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.tt.framework.utils.zlb.HmacAuthUtil;
import cn.smarthse.tt.manage.zlb.IZlbClientServiceService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZlbClientServiceService
implements IZlbClientServiceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbClientServiceService.class);
    @Value(value="${zlb.host}")
    private String host;
    private static final String access_token = "/restapi/prod/IC33000020220329000007/uc/sso/access_token";
    private static final String getUserInfo = "/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo";
    @Value(value="${zlb.appKey}")
    private String appKey;
    @Value(value="${zlb.appSecret}")
    private String appSecret;

    @Override
    public String getClientTicketCode(String ticketId, String appKey, String appSecret, String appId) {
        String url = this.host + access_token;
        Map<String, String> header = HmacAuthUtil.generateHeader(url, "POST", appKey, appSecret);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("ticketId", ticketId);
        params.put("appId", appId);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42start {}", (Object)ticketId);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)url).addHeaders(header)).body(JSON.toJSONString(params)).execute();
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)execute.body());
        JSONObject resultJson = JSONObject.parseObject((String)execute.body());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : resultJson.keySet()) {
            resultMap.put(key, resultJson.get((Object)key));
        }
        if (((Boolean)resultMap.get("success")).booleanValue()) {
            return ((JSONObject)resultMap.get("data")).getString("accessToken");
        }
        return null;
    }

    @Override
    public ZlbUserInfo getClientInfoByToken(String token, String appKey, String appSecret) {
        String url = this.host + getUserInfo;
        Map<String, String> header = HmacAuthUtil.generateHeader(url, "POST", appKey, appSecret);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("token", token);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u8bf7\u6c42start {}", (Object)token);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)url).addHeaders(header)).body(JSON.toJSONString(params)).execute();
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)execute.body());
        JSONObject resultJson = JSONObject.parseObject((String)execute.body());
        if (resultJson.getBoolean("success").booleanValue()) {
            return (ZlbUserInfo)JSONObject.parseObject((String)resultJson.getString("data"), ZlbUserInfo.class);
        }
        return null;
    }

    @Override
    public ZlbUserInfo getZlbUserInfo(String ticket, String appId) {
        String token = this.getClientTicketCode(ticket, this.appKey, this.appSecret, appId);
        if (token == null) {
            return null;
        }
        return this.getClientInfoByToken(token, this.appKey, this.appSecret);
    }
}

