/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.manage;

import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.tt.converter.CommonConverter;
import cn.smarthse.tt.model.vo.sys.AreaVo;
import cn.smarthse.tt.model.vo.sys.EconomyVo;
import cn.smarthse.tt.model.vo.sys.IndustryDetailVo;
import cn.smarthse.tt.model.vo.sys.IndustryVo;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommonManage {
    private final CommonConverter converter;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;

    public List<AreaVo> getAreaList(Long pid) {
        return this.converter.areaModel2AreaVo(this.areaProvideService.getChildByParentId(Long.valueOf(pid == null ? 0L : pid), null));
    }

    public List<IndustryDetailVo> getIndustryList(Long pid) {
        return this.converter.industryModel2IndustryDetailVo(this.industryProvideService.getIndustryListByPid(Long.valueOf(pid == null ? 2478L : pid)));
    }

    @Cacheable(value={"industry=24"}, key="'all'", condition="#keyword == null")
    public List<IndustryVo> searchIndustryList4(String keyword) {
        return this.converter.industryModel2IndustryVo(this.industryProvideService.searchIndustryList4(keyword));
    }

    @Cacheable(value={"economyList=24"}, key="'all'")
    public List<EconomyVo> getEconomyList() {
        List list = this.sysParamProvideService.getSysParamList("registration_type");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        list.removeIf(record -> record.getParentId() == null);
        return this.converter.sysParamModel2EconomyVo(list);
    }

    @Generated
    public CommonManage(CommonConverter converter) {
        this.converter = converter;
    }
}

