/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.framework.uploader.m3u8;

import cn.smarthse.tt.framework.uploader.m3u8.MediaInfo;
import cn.smarthse.tt.framework.uploader.m3u8.TranscodeConfig;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FFmpegUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FFmpegUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegUtils.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private static byte[] genAesKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            return keyGenerator.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static Path genKeyInfo(String folder) throws IOException {
        byte[] aesKey = FFmpegUtils.genAesKey();
        String iv = Hex.encodeHexString((byte[])FFmpegUtils.genAesKey());
        Path keyFile = Paths.get(folder, "key");
        Files.write(keyFile, aesKey, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("key").append(LINE_SEPARATOR).append(keyFile).append(LINE_SEPARATOR).append(iv);
        Path keyInfo = Paths.get(folder, "key_info");
        Files.write(keyInfo, stringBuilder.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return keyInfo;
    }

    private static void genIndex(String file, String indexPath, String bandWidth) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#EXTM3U").append(LINE_SEPARATOR).append("#EXT-X-STREAM-INF:BANDWIDTH=").append(bandWidth).append(LINE_SEPARATOR).append(indexPath);
        Files.write(Paths.get(file, new String[0]), stringBuilder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void transcodeToM3u8(String source, String destFolder, TranscodeConfig config) throws IOException, InterruptedException {
        if (!Files.exists(Paths.get(source, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + source);
        }
        Path workDir = Paths.get(destFolder, new String[0]);
        Files.createDirectories(workDir, new FileAttribute[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("ffmpeg");
        commands.add("-i");
        commands.add(source);
        commands.add("-c:v");
        commands.add("copy");
        commands.add("-c:a");
        commands.add("copy");
        commands.add("-hls_time");
        commands.add(config.getTsSeconds());
        commands.add("-hls_playlist_type");
        commands.add("vod");
        commands.add("-hls_segment_filename");
        commands.add("%06d.ts");
        if (StringUtils.hasText((String)config.getCutStart())) {
            commands.add("-ss");
            commands.add(config.getCutStart());
        }
        if (StringUtils.hasText((String)config.getCutEnd())) {
            commands.add("-to");
            commands.add(config.getCutEnd());
        }
        commands.add("index.m3u8");
        Process process = new ProcessBuilder(new String[0]).command(commands).directory(workDir.toFile()).start();
        new Thread(() -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    LOGGER.debug(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        new Thread(() -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException("\u89c6\u9891\u5207\u7247\u5f02\u5e38");
        }
        if (!FFmpegUtils.screenShots(source, String.join((CharSequence)File.separator, destFolder, "poster.jpg"), config.getPoster())) {
            throw new RuntimeException("\u5c01\u9762\u622a\u53d6\u5f02\u5e38");
        }
        MediaInfo mediaInfo = FFmpegUtils.getMediaInfo(source);
        if (mediaInfo == null) {
            throw new RuntimeException("\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\u5f02\u5e38");
        }
        FFmpegUtils.genIndex(String.join((CharSequence)File.separator, destFolder, "master.m3u8"), "index.m3u8", mediaInfo.getFormat().getBitRate());
    }

    public static MediaInfo getMediaInfo(String source) throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("ffprobe");
        commands.add("-i");
        commands.add(source);
        commands.add("-show_format");
        commands.add("-show_streams");
        commands.add("-print_format");
        commands.add("json");
        Process process = new ProcessBuilder(commands).start();
        MediaInfo mediaInfo = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            mediaInfo = (MediaInfo)new Gson().fromJson((Reader)bufferedReader, MediaInfo.class);
        }
        catch (IOException e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
        if (process.waitFor() != 0) {
            return null;
        }
        return mediaInfo;
    }

    public static boolean screenShots(String source, String file, String time) throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("ffmpeg");
        commands.add("-i");
        commands.add(source);
        commands.add("-ss");
        commands.add(time);
        commands.add("-y");
        commands.add("-q:v");
        commands.add("1");
        commands.add("-frames:v");
        commands.add("1");
        commands.add("-f");
        commands.add("image2");
        commands.add(file);
        Process process = new ProcessBuilder(commands).start();
        new Thread(() -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    LOGGER.debug(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        new Thread(() -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        return process.waitFor() == 0;
    }
}

