/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.framework.uploader;

import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.smarthse.tt.framework.uploader.FileMD5;
import cn.smarthse.tt.framework.uploader.UploadFileParameter;
import cn.smarthse.tt.framework.uploader.UploadFilePathEnum;
import cn.smarthse.tt.framework.uploader.UploadState;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class FileUpload {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUpload.class);
    public static String[] filePostfixs = new String[]{"*"};
    public static String[] typeImages = new String[]{"gif", "jpeg", "png", "jpg", "tif", "bmp"};
    public static String[] typeOthers = new String[]{"html", "htm", "doc", "xls", "txt", "zip", "rar", "pdf", "cll"};
    public static long maxFileSize = 0xC800000L;
    public static int bufferSize = 8;

    private static final void init() {
        if (bufferSize > Integer.MAX_VALUE) {
            bufferSize = 8192;
        } else if (bufferSize < 8) {
            bufferSize = 8;
        }
        if (maxFileSize < 1L) {
            maxFileSize = 0x80000000L;
        } else if (maxFileSize > Long.MAX_VALUE) {
            maxFileSize = 0x80000000L;
        }
    }

    public static UploadState upload4Stream(String fileName, String path, InputStream is) throws Exception {
        FileUpload.init();
        UploadState state = UploadState.UPLOAD_FAILURE;
        OutputStream fos = null;
        try {
            FileUpload.mkDir(path);
            fos = new FileOutputStream(path + fileName);
            byte[] buffer = new byte[bufferSize];
            int len = 0;
            while ((len = is.read(buffer)) > 0) {
                ((FileOutputStream)fos).write(buffer, 0, len);
            }
            state = UploadState.UPLOAD_SUCCSSS;
        }
        catch (FileNotFoundException e) {
            state = UploadState.UPLOAD_NOTFOUND;
            throw e;
        }
        catch (IOException e) {
            state = UploadState.UPLOAD_FAILURE;
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
        }
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, File file) throws Exception {
        FileUpload.init();
        UploadState state = UploadState.UPLOAD_FAILURE;
        try (FileInputStream fis = null;){
            long size = file.length();
            if (size <= 0L) {
                state = UploadState.UPLOAD_ZEROSIZE;
            } else if (size <= maxFileSize) {
                fis = new FileInputStream(file);
                state = FileUpload.upload4Stream(fileName, path, fis);
            } else {
                state = UploadState.UPLOAD_OVERSIZE;
            }
        }
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, File file, String[] allowTypes) throws Exception {
        UploadState state = UploadState.UPLOAD_FAILURE;
        state = FileUpload.validTypeByName(fileName, allowTypes) ? FileUpload.upload4Stream(fileName, path, file) : UploadState.UPLOAD_TYPE_ERROR;
        return state;
    }

    public static UploadState upload4Stream(String fileName, String path, InputStream fs, String[] allowTypes) throws Exception {
        UploadState state = UploadState.UPLOAD_FAILURE;
        state = FileUpload.validTypeByName(fileName, allowTypes) ? FileUpload.upload4Stream(fileName, path, fs) : UploadState.UPLOAD_TYPE_ERROR;
        return state;
    }

    public static boolean upload4CopyFile(String fileName, String path, File file) throws Exception {
        FileUpload.init();
        boolean success = false;
        if (file.length() <= maxFileSize) {
            FileUpload.mkDir(path);
            File destFile = new File(path, fileName);
            FileUtils.copyFile((File)file, (File)destFile);
            success = true;
        }
        return success;
    }

    public static boolean upload4CopyFile(String fileName, String path, File file, String[] allowTypes) throws Exception {
        boolean success = false;
        if (FileUpload.validTypeByName(fileName, allowTypes)) {
            success = FileUpload.upload4CopyFile(fileName, path, file);
        }
        return success;
    }

    public static boolean validTypeByName(String fileName, String[] allowTypes, boolean flag) {
        String suffix = FileUpload.getType(fileName);
        boolean valid = false;
        if (allowTypes.length > 0 && "*".equals(allowTypes[0])) {
            valid = true;
        } else {
            for (String type : allowTypes) {
                if (flag) {
                    if (suffix == null || !suffix.equalsIgnoreCase(type)) continue;
                    valid = true;
                    break;
                }
                if (suffix == null || !suffix.equals(type)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    public static boolean validTypeByName(String fileName, String[] allowTypes) {
        return FileUpload.validTypeByName(fileName, allowTypes, true);
    }

    public static boolean validTypeByPostfix(String suffix, String[] allowTypes, boolean flag) {
        boolean valid = false;
        if (allowTypes.length > 0 && "*".equals(allowTypes[0])) {
            valid = true;
        } else {
            for (String type : allowTypes) {
                if (flag) {
                    if (suffix == null || !suffix.equalsIgnoreCase(type)) continue;
                    valid = true;
                    break;
                }
                if (suffix == null || !suffix.equals(type)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    public static boolean validTypeByPostfix(String suffix, String[] allowTypes) {
        return FileUpload.validTypeByPostfix(suffix, allowTypes, true);
    }

    public static boolean validTypeByPostfix4Images(String suffix) {
        return FileUpload.validTypeByPostfix(suffix, typeImages);
    }

    public static boolean validTypeByPostfix4Others(String suffix) {
        return FileUpload.validTypeByPostfix(suffix, typeOthers);
    }

    public static boolean validTypeByName4Images(String fileName) {
        return FileUpload.validTypeByName(fileName, typeImages);
    }

    public static boolean validTypeByName4Others(String fileName) {
        return FileUpload.validTypeByName(fileName, typeOthers);
    }

    public static boolean removeFile(String fileName, String path) {
        boolean flag = false;
        if (FileUpload.isFileExist(fileName, path)) {
            File file = new File(path + fileName);
            flag = file.delete();
        }
        return flag;
    }

    public static boolean removeFile(File file) {
        boolean flag = false;
        if (file != null && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    public static boolean removeFile(String path) {
        return FileUpload.removeFile(new File(path));
    }

    public static boolean removeFile4Dir(File file) {
        boolean flag = false;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] allFile;
            for (File f : allFile = file.listFiles()) {
                flag = f.delete();
                if (flag) continue;
                System.err.println("\u5220\u9664\u6587\u4ef6" + f.getAbsolutePath() + "\u51fa\u9519\u4e86\uff01");
                break;
            }
        }
        return flag;
    }

    public static boolean removeFile4Dir(String path) {
        return FileUpload.removeFile4Dir(new File(path));
    }

    public static boolean removeAllFile4Dir(File file) {
        boolean flag = false;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] allFile;
            for (File f : allFile = file.listFiles()) {
                flag = !f.isDirectory() ? f.delete() : FileUpload.removeAllFile4Dir(f);
                if (flag) continue;
                System.err.println("\u5220\u9664\u6587\u4ef6" + f.getAbsolutePath() + "\u51fa\u9519\u4e86\uff01");
                break;
            }
        }
        return flag;
    }

    public static boolean removeAllFile4Dir(String path) {
        return FileUpload.removeAllFile4Dir(new File(path));
    }

    public static String getType(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            String suffix = fileName.substring(index + 1);
            return suffix;
        }
        return null;
    }

    public static String getNewFileName(String fileName, String newName, String nullSuffix) {
        String suffix = FilenameUtils.getExtension((String)fileName);
        newName = suffix != null ? newName.concat(".").concat(suffix) : newName.concat(".").concat(nullSuffix);
        return newName;
    }

    public static String getRandomName(String fileName, String defalutExds) {
        String randomName = UUID.randomUUID().toString();
        return FileUpload.getNewFileName(fileName, randomName, defalutExds);
    }

    public static String getNumberName(String fileName, String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddhhmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return FileUpload.getNewFileName(fileName, numberName, defalutExds);
    }

    public static boolean isFileExist(String fileName, String path) {
        File file = new File(path + fileName);
        return file.exists();
    }

    public static String getBracketFileName(String fileName, String path) {
        return FileUpload.getBracketFileName(fileName, fileName, path, 1);
    }

    public static String getBracketFileName(String fileName, String bracketName, String path, int num) {
        boolean exist = FileUpload.isFileExist((String)bracketName, path);
        if (exist) {
            int index = fileName.lastIndexOf(".");
            String suffix = "";
            bracketName = fileName;
            if (index != -1) {
                suffix = fileName.substring(index);
                bracketName = fileName.substring(0, index);
            }
            bracketName = (String)bracketName + "(" + num + ")" + suffix;
            bracketName = FileUpload.getBracketFileName(fileName, (String)bracketName, path, ++num);
        }
        return bracketName;
    }

    public static String getDoPath(String path) {
        return path.replace("\\", "/");
    }

    public static boolean mkDir(String path) throws Exception {
        File file = null;
        try {
            file = new File(path);
            if (!file.exists()) {
                boolean bl = file.mkdirs();
                return bl;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            file = null;
        }
        return true;
    }

    public static UploadFileParameter upload_pluploader(UploadFileParameter up) {
        try {
            MultipartFile file;
            HttpServletRequest request = up.getRequest();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            if ((up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) && (file = multipartRequest.getFile("file")) != null && file.getSize() > 0L) {
                up.setMultipartFile(file);
            }
            if (up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) {
                up.setUploadState(UploadState.UPLOAD_ZEROSIZE);
                return up;
            }
            MultipartFile multipartFile = up.getMultipartFile();
            String realPath = up.getRealPath() + UploadFileParameter.FILE_PATH_SEP;
            File frealPath = new File(realPath);
            try {
                frealPath.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream inputStream = multipartFile.getInputStream();
            String resourceFileName = up.getMultipartFile().getOriginalFilename();
            up.setOriginalFilename(resourceFileName);
            up.setHashCode(FileMD5.getFileMD5(up.getMultipartFile().getBytes()));
            up.setFilesize(up.getMultipartFile().getSize());
            up.setFileExt(FilenameUtils.getExtension((String)resourceFileName));
            up.setFileName(FileUpload.getNumberName(resourceFileName, up.getFileExt()));
            up.setFile(new File(realPath + up.getFileName()));
            up.setRealPath(realPath);
            up.setOssUrl((up.getUploadDir() + "/" + up.getFileName()).replace("\\", "/"));
            up.setIp(JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            FileUtils.copyToFile((InputStream)up.getMultipartFile().getInputStream(), (File)up.getFile());
            up.setUploadState(UploadState.UPLOAD_SUCCSSS);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
        return up;
    }

    public static List<File> uploadBySWF(UploadFileParameter up) throws Exception {
        ArrayList<File> files;
        block7: {
            files = new ArrayList<File>();
            try {
                UploadFilePathEnum thispath;
                if (up.getMultipartFile() != null && up.getMultipartFile().getSize() != 0L) break block7;
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)up.getRequest();
                String realpath = up.getRequest().getSession().getServletContext().getRealPath("/") + UploadFileParameter.FILE_PATH;
                String path = realpath + (thispath = UploadFilePathEnum.getCode(up.getType())).getPath() + UploadFileParameter.FILE_PATH_SEP;
                File filepath = new File(path);
                if (!filepath.exists()) {
                    try {
                        filepath.mkdirs();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Iterator iter = multipartRequest.getFileNames();
                while (iter.hasNext()) {
                    String filename = null;
                    MultipartFile file = multipartRequest.getFile((String)iter.next());
                    if (file != null) {
                        filename = path + FileUpload.getRandomName(file.getOriginalFilename(), up.getFileExt());
                        File localFile = new File(filename);
                        file.transferTo(localFile);
                        files.add(localFile);
                        up.setOriginalFilename(file.getOriginalFilename());
                    }
                    filename = null;
                }
                path = null;
                Object var3_4 = null;
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
        return files;
    }

    public static void inputStreamToFile(InputStream ins, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
    }
}

