/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.framework.model;

import cn.smarthse.tt.framework.model.ResponseStateEnum;
import java.io.Serializable;
import lombok.Generated;

public class ResponseData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ResponseStateEnum state = ResponseStateEnum.success;
    private String message = ResponseStateEnum.success.getName();
    private T result;

    public ResponseData(ResponseStateEnum state, String message, T result) {
        this.state = state;
        this.message = message;
        this.result = result;
    }

    public ResponseData(ResponseStateEnum state, String message) {
        this.state = state;
        this.message = message;
    }

    public ResponseData(ResponseStateEnum state, T result) {
        this.state = state;
        this.message = state.getName();
        this.result = result;
    }

    public ResponseData(String message, T result) {
        this.message = message;
        this.result = result;
    }

    public ResponseData(T result) {
        this.message = ResponseStateEnum.success.getName();
        this.result = result;
    }

    public ResponseData(String message) {
        this.message = message;
    }

    public ResponseData(ResponseStateEnum state) {
        this(state, state.getName());
    }

    public static ResponseData<String> success() {
        return new ResponseData<String>();
    }

    public static <T> ResponseData<T> success(T result) {
        return new ResponseData<T>(ResponseStateEnum.success, result);
    }

    public static <T> ResponseData<T> success(String message) {
        return new ResponseData<String>(ResponseStateEnum.success, message);
    }

    public static <T> ResponseData<T> success(String message, T result) {
        return new ResponseData<T>(ResponseStateEnum.success, message, result);
    }

    public static ResponseData<String> fail() {
        return new ResponseData<String>(ResponseStateEnum.fail);
    }

    public static <T> ResponseData<T> fail(T result) {
        return new ResponseData<T>(ResponseStateEnum.fail, ResponseStateEnum.fail.getName(), result);
    }

    public static <T> ResponseData<T> fail(String message) {
        return new ResponseData<String>(ResponseStateEnum.fail, message);
    }

    public static <T> ResponseData<T> fail(String message, T result) {
        return new ResponseData<T>(ResponseStateEnum.fail, message, result);
    }

    public static ResponseData<String> response(ResponseStateEnum state) {
        return new ResponseData<String>(state);
    }

    public static ResponseData<String> response(ResponseStateEnum state, String message) {
        return new ResponseData<String>(state, message);
    }

    public static <T> ResponseData<T> response(ResponseStateEnum state, String message, T result) {
        return new ResponseData<T>(state, message, result);
    }

    @Generated
    public ResponseData() {
    }

    @Generated
    public ResponseStateEnum getState() {
        return this.state;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Generated
    public void setState(ResponseStateEnum state) {
        this.state = state;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setResult(T result) {
        this.result = result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseStateEnum this$state = this.getState();
        ResponseStateEnum other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseStateEnum $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResponseData(state=" + String.valueOf((Object)this.getState()) + ", message=" + this.getMessage() + ", result=" + String.valueOf(this.getResult()) + ")";
    }
}

