/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.framework.filter;

import cn.smarthse.tt.framework.filter.MultiReadHttpServletRequest;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

@WebFilter(filterName="MultiReadHttpServletRequestFilter")
public class MultiReadHttpServletRequestFilter
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        MultiReadHttpServletRequest multiReadRequest = null;
        String contentType = servletRequest.getContentType();
        if (contentType != null && contentType.startsWith("application/json") && servletRequest instanceof HttpServletRequest) {
            multiReadRequest = new MultiReadHttpServletRequest((HttpServletRequest)servletRequest);
        }
        if (multiReadRequest == null) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter(multiReadRequest, servletResponse);
        }
    }
}

