/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.framework.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.tt.bootstrap.security.service.ShiroUtil;
import cn.smarthse.tt.framework.utils.ServletUtils;
import cn.smarthse.tt.service.sys.ISpecialistUserService;
import cn.smarthse.tt.service.sys.ISysLogService;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ISysLogService logService;
    private final ISpecialistUserService specialistUserService;

    @Pointcut(value=" @annotation(cn.smarthse.common.annotation.Log)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object afterCompletion(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object proceed = joinPoint.proceed();
        this.addLog(method.getAnnotation(Log.class));
        return proceed;
    }

    private void addLog(Log logAnno) {
        if (logAnno != null) {
            byte type = logAnno.type();
            HttpServletRequest request = ServletUtils.getRequest();
            SysLog syslog = new SysLog();
            Long userId = ShiroUtil.getUserId();
            syslog.setUsername(ShiroUtil.getLoginUsername());
            syslog.setFullname(ShiroUtil.getLoginUsername());
            syslog.setTitle(logAnno.title());
            syslog.setType(Byte.valueOf(type));
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
            Map parameterMap = request.getParameterMap();
            syslog.setParams(type == 1 || type == 26 ? null : (CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : JakartaServletUtil.getBody((ServletRequest)request)));
            syslog.setRequestUri(request.getRequestURI());
            syslog.setUserAgent(request.getHeader("user-agent"));
            syslog.setLogSource(Byte.valueOf(LogConstans.THROUGHTRAIN.getValue().byteValue()));
            syslog.setCreateDate(new Date());
            syslog.setCreateBy(userId);
            try {
                if (this.taskExecutor != null) {
                    this.taskExecutor.execute(() -> this.logService.addLog(syslog));
                } else {
                    this.logService.addLog(syslog);
                }
            }
            catch (Exception e) {
                log.error("Exception: ", (Throwable)e);
            }
        }
    }

    @Generated
    public LogAspect(ThreadPoolTaskExecutor taskExecutor, ISysLogService logService, ISpecialistUserService specialistUserService) {
        this.taskExecutor = taskExecutor;
        this.logService = logService;
        this.specialistUserService = specialistUserService;
    }
}

