/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.controller.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.logback.SensitiveConverter;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.health.supervise.enums.sys.UserFromEnum;
import cn.smarthse.tt.bootstrap.security.service.ShiroUtil;
import cn.smarthse.tt.controller.ControllerSupport;
import cn.smarthse.tt.entity.SpecialistQuickQuestion;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.framework.bean.SensitiveWordFiltering;
import cn.smarthse.tt.model.SpecialistQuickCommunicateModel;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.service.sys.ISensitiveWordFilteringService;
import cn.smarthse.tt.service.tt.ISpecialistQuickCommunicateService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.task.TransferQuestionTask;
import cn.smarthse.tt.vo.SpecialistQuickCommunicateVo;
import cn.smarthse.tt.vo.SpecialistQuickQuestionVo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/question"})
@RestController
public class SpecialistQuickQuestionAnswerController
extends ControllerSupport {
    private final ISpecialistQuickQuestionService quickQuestionService;
    private final ISpecialistQuickCommunicateService quickCommunicateService;
    private final ISensitiveWordFilteringService filteringService;
    private final TransferQuestionTask transferQuestionTask;

    @GetMapping(value={"/questionPage"})
    public ResponseData<PageInfo<SpecialistQuickQuestionVo>> getSpecialistQuestionPage(JqGridParam pageParam, SpecialistQuickQuestionModel queParam) {
        if (queParam == null) {
            queParam = new SpecialistQuickQuestionModel();
        }
        queParam.setUser(ShiroUtil.getShiroPrincipal().getUser());
        PageInfo<SpecialistQuickQuestionVo> questionPage = this.quickQuestionService.getSpecialistQuestionPage(pageParam, queParam);
        return ResponseData.success(questionPage);
    }

    @GetMapping(value={"/questionDetail"})
    public ResponseData<SpecialistQuickQuestionVo> getQuestionDetail(Long id) {
        SpecialistUser user = ShiroUtil.getShiroPrincipal().getUser();
        SpecialistQuickQuestionVo questionDetail = this.quickQuestionService.getQuestionDetail(user, id);
        return ResponseData.success((Object)questionDetail);
    }

    @GetMapping(value={"/communicateList"})
    public ResponseData<List<SpecialistQuickCommunicateVo>> getSpecialistCommunicateList(SpecialistQuickCommunicateModel commParam) {
        if (commParam == null) {
            commParam = new SpecialistQuickCommunicateModel();
        }
        commParam.setUser(ShiroUtil.getShiroPrincipal().getUser());
        commParam.setUserFrom(UserFromEnum.ZZD.getCode());
        List<SpecialistQuickCommunicateVo> communicateList = this.quickCommunicateService.getSpecialistCommunicateList(commParam);
        return ResponseData.success(communicateList);
    }

    @PostMapping(value={"/askQuestion"})
    public ResponseData<String> askQuestion(@RequestBody SpecialistQuickQuestionModel queParam) {
        if (queParam == null) {
            queParam = new SpecialistQuickQuestionModel();
        }
        queParam.setUser(ShiroUtil.getShiroPrincipal().getUser());
        Pair<Integer, String> pair = this.quickQuestionService.askQuestion(queParam);
        Integer key = (Integer)pair.getKey();
        String value = (String)pair.getValue();
        if (Objects.equals(key, ResponseStateEnum.fail.getValue())) {
            return ResponseData.fail((String)value);
        }
        return ResponseData.success((String)value);
    }

    @GetMapping(value={"/hasUnFinishQuestion"})
    public ResponseData<Boolean> hasUnFinishQuestion() {
        SpecialistUser user = ShiroUtil.getShiroPrincipal().getUser();
        return ResponseData.success((Object)this.quickQuestionService.hasUnFinishQuestion(user));
    }

    @GetMapping(value={"/lastQuestion"})
    public ResponseData<SpecialistQuickQuestion> getLastQuestion() {
        Long userId = ShiroUtil.getShiroPrincipal().getUser().getId();
        SpecialistQuickQuestion lastQuestion = this.quickQuestionService.getLastQuestion(userId);
        return ResponseData.success((Object)lastQuestion);
    }

    @GetMapping(value={"/judgeSensitive"})
    public ResponseData<SensitiveWordFiltering> judgeHasSensitiveWord(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return ResponseData.fail((String)"\u5165\u53c2\u5b57\u8bcd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        SensitiveWordFiltering sensitive = this.filteringService.sensitiveWordFiltering(str);
        return ResponseData.success((Object)sensitive);
    }

    @PostMapping(value={"/doReply"})
    public ResponseData<String> doReply(@RequestBody SpecialistQuickCommunicateModel commParam) {
        if (commParam == null) {
            commParam = new SpecialistQuickCommunicateModel();
        }
        commParam.setUser(ShiroUtil.getShiroPrincipal().getUser());
        this.quickCommunicateService.doReply(commParam);
        return ResponseData.success();
    }

    @PostMapping(value={"/finishQuestion"})
    public ResponseData<String> finishQuestion(@RequestBody SpecialistQuickQuestionModel queParam) {
        if (queParam == null) {
            queParam = new SpecialistQuickQuestionModel();
        }
        queParam.setUser(ShiroUtil.getShiroPrincipal().getUser());
        this.quickQuestionService.finishQuestion(queParam);
        return ResponseData.success();
    }

    @GetMapping(value={"transferQuestionTask"})
    public ResponseData<String> transferQuestionTask() {
        this.transferQuestionTask.handleOvertimeTransfer();
        return ResponseData.success();
    }

    private static void expertInfoDesensitization(List<SpecialistQuickCommunicateVo> communicateList) {
        if (CollUtil.isNotEmpty(communicateList)) {
            communicateList.stream().filter(c -> Objects.equals(c.getType(), 1) || Objects.equals(c.getType(), 2)).forEach(c -> c.setPersonName(StrUtil.isBlank((CharSequence)c.getPersonName()) ? "" : SensitiveConverter.maskPartialData((String)c.getPersonName(), (int)0, (int)1)));
        }
    }

    @Generated
    public SpecialistQuickQuestionAnswerController(ISpecialistQuickQuestionService quickQuestionService, ISpecialistQuickCommunicateService quickCommunicateService, ISensitiveWordFilteringService filteringService, TransferQuestionTask transferQuestionTask) {
        this.quickQuestionService = quickQuestionService;
        this.quickCommunicateService = quickCommunicateService;
        this.filteringService = filteringService;
        this.transferQuestionTask = transferQuestionTask;
    }
}

