/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.controller.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.logback.SensitiveConverter;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.tt.bootstrap.security.service.ShiroUtil;
import cn.smarthse.tt.controller.ControllerSupport;
import cn.smarthse.tt.dto.SpecialistInfoDto;
import cn.smarthse.tt.entity.ReplyTemplate;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.SpecialistQuestionRecord;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.framework.annotation.RequestLimit;
import cn.smarthse.tt.model.ReplyTemplateModel;
import cn.smarthse.tt.model.SpecialistInfoModel;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.provider.supervise.ISpecialistInfoProviderToSupervise;
import cn.smarthse.tt.service.tt.IReplyTemplateService;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import cn.smarthse.tt.service.tt.ISpecialistQuestionRecordService;
import cn.smarthse.tt.service.tt.ISpecialistQuickQuestionService;
import cn.smarthse.tt.vo.SpecialistInfoVo;
import cn.smarthse.tt.vo.SpecialistQuestionRecordVo;
import cn.smarthse.tt.vo.SpecialistQuickQuestionVo;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/specialist"})
public class SpecialistController
extends ControllerSupport {
    private final ISpecialistQuestionRecordService questionRecordService;
    private final ISpecialistInfoService specialistInfoService;
    private final ISpecialistInfoProviderToSupervise specialistInfoProvider;
    private final ISpecialistQuickQuestionService questionService;
    private final IReplyTemplateService replyTemplateService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyService;

    @PostMapping(value={"/transferQuestion"})
    public ResponseData<Long> transferQuestion(@RequestBody SpecialistQuestionRecord record) {
        record.setTransferType(Integer.valueOf(1));
        SpecialistQuestionRecord questionRecord = this.questionRecordService.transferQuestion(record, ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
        if (questionRecord != null) {
            record.setTransferSpecialistId(questionRecord.getTransferSpecialistId());
            Long receiveId = this.questionService.transferAndMatchExpertId(record);
            this.questionRecordService.setReceiveSpecialist(record.getQuestionId(), record.getUpdateDate(), receiveId, ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
            return ResponseData.success((Object)questionRecord.getId());
        }
        return ResponseData.fail(null);
    }

    @GetMapping(value={"/getTransferList"})
    public ResponseData<List<SpecialistQuestionRecordVo>> getTransferList(Long questionId) {
        if (questionId == null) {
            return ResponseData.fail((String)"\u95ee\u9898id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<SpecialistQuestionRecordVo> transferList = this.questionRecordService.getTransferList(questionId);
        return ResponseData.success(transferList);
    }

    @Log(title="\u4e13\u5bb6\u4fe1\u606f\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/getSpecialistInfoList"})
    public ResponseData<PageInfo<SpecialistInfoVo>> getSpecialistInfoList(SpecialistInfoModel model) {
        PageInfo<SpecialistInfoVo> data = this.specialistInfoService.getSpecialistInfoListToUser(model);
        data.getList().forEach(vo -> {
            if (vo.getFaceId() != null) {
                vo.setFace(this.sysFileProvideService.getFileById(vo.getFaceId()));
            }
        });
        return ResponseData.success(data);
    }

    @RepeatUrlFormData
    @Log(title="\u4e13\u5bb6\u6863\u6848\u4fe1\u606f\u5bfc\u5165", type=23)
    @PostMapping(value={"/import"})
    @RequestLimit(second=10, maxCount=1)
    public ResponseData<String> importSpecialist(Long fileId) throws IOException {
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (file == null) {
            return ResponseData.fail((String)"\u6587\u4ef6\u4e3a\u7a7a");
        }
        Long userId = ShiroUtil.getShiroPrincipal().getUser().getId();
        this.specialistInfoProvider.importSpecialist(file, Integer.valueOf(1), userId);
        return ResponseData.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @Log(title="\u4e13\u5bb6\u4fe1\u606f\u4fdd\u5b58")
    @PostMapping(value={"/saveSpecialistInfo"})
    public ResponseData<String> saveSpecialistInfo(@RequestBody SpecialistInfoDto dto) {
        AreaModel area;
        SpecialistUser user;
        SpecialistInfo dbInfo;
        if (dto.getId() == null) {
            ResponseData.fail((String)"\u4e13\u5bb6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((dbInfo = (SpecialistInfo)this.specialistInfoService.getById((user = ShiroUtil.getShiroPrincipal().getUser()).getSpecialistId())) == null || !dbInfo.getId().equals(dto.getId())) {
            return ResponseData.fail((String)"\u60a8\u767b\u5f55\u7684\u8d26\u53f7\u548c\u60a8\u64cd\u4f5c\u7684\u8d26\u53f7\u4e0d\u662f\u540c\u4e00\u4e2a");
        }
        if (dto.getAreaId() != null && (area = this.sysAreaProvideService.getAreaById(dto.getAreaId())) != null) {
            dto.setAreaAddress(area.getFullname());
        }
        dto.setFullname(dbInfo.getFullname());
        dto.setUserMobile(dbInfo.getUserMobile());
        this.specialistInfoService.saveSpecialistInfo(dto, 1, user.getSpecialistId());
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Log(title="\u4e13\u5bb6\u4fe1\u606f\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"/getSpecialistInfoById"})
    public ResponseData<SpecialistInfoVo> getSpecialistInfoById(Long id) {
        SpecialistInfoVo vo = this.specialistInfoService.getSpecialistInfoById(id, false);
        if (id == null || vo == null) {
            return ResponseData.fail((String)"\u4f20\u5165ID\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4e13\u5bb6");
        }
        if (vo.getFaceId() != null) {
            vo.setFace(this.sysFileProvideService.getFileById(vo.getFaceId()));
        }
        return ResponseData.success((Object)vo);
    }

    @Log(title="\u95ee\u9898\u6700\u65b0\u5339\u914d\u7684\u4e13\u5bb6\u4fe1\u606f")
    @GetMapping(value={"/getLatestSpecialistInfo"})
    public ResponseData<SpecialistInfoVo> getLatestSpecialistInfo(Long questionId) {
        SpecialistInfoVo vo = this.specialistInfoService.getLatestSpecialistInfo(questionId);
        if (vo != null && vo.getFaceId() != null) {
            vo.setFace(this.sysFileProvideService.getFileById(vo.getFaceId()));
        }
        return ResponseData.success((Object)vo);
    }

    @Log(title="\u4e13\u5bb6\u6761\u4ef6\u67e5\u8be2\u95ee\u9898\u5217\u8868")
    @GetMapping(value={"/getQuestionListBySearch"})
    public ResponseData<PageInfo<SpecialistQuickQuestionVo>> getQuestionListBySearch(JqGridParam pageParam, SpecialistQuickQuestionModel queParam) {
        queParam.setExpertId(ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
        PageInfo<SpecialistQuickQuestionVo> questionPage = this.questionService.getQuestionListBySearch(pageParam, queParam);
        return ResponseData.success(questionPage);
    }

    @Log(title="\u95ee\u9898\u8be6\u60c5")
    @GetMapping(value={"/getQuestionInfo"})
    public ResponseData<SpecialistQuickQuestionVo> getQuestionInfo(Long id) {
        SpecialistQuickQuestionVo question = this.questionService.getQuestionInfo(id, ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
        return ResponseData.success((Object)question);
    }

    @Log(title="\u56de\u590d\u6a21\u7248\u5217\u8868")
    @GetMapping(value={"/getTemplateList"})
    public ResponseData<List<ReplyTemplate>> getTemplateList() {
        return ResponseData.success(this.replyTemplateService.getPageList(ShiroUtil.getShiroPrincipal().getUser().getSpecialistId()));
    }

    @Log(title="\u6536\u85cf\u56de\u590d")
    @PostMapping(value={"/addTemplateList"})
    public ResponseData<String> addTemplateList(@RequestBody ReplyTemplateModel model) {
        model.setSpecialistId(ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
        this.replyTemplateService.addTemplateList(model);
        return ResponseData.success();
    }

    @Log(title="\u53d6\u6d88\u6536\u85cf")
    @PostMapping(value={"/deleteTemplateList"})
    public ResponseData<String> deleteTemplateList(@RequestBody ReplyTemplateModel model) {
        model.setSpecialistId(ShiroUtil.getShiroPrincipal().getUser().getSpecialistId());
        this.replyTemplateService.deleteTemplateList(model);
        return ResponseData.success();
    }

    @GetMapping(value={"/companyPage"})
    public ResponseData<JqGridData<CompanySuperviseModel>> getCompanyPage(CompanySuperviseSearchModel comParam, int page, int rows) {
        SpecialistUser user = ShiroUtil.getShiroPrincipal().getUser();
        JqGridData<CompanySuperviseModel> companyPage = this.questionService.getCompanyPage(comParam, user, page, rows);
        return ResponseData.success(companyPage);
    }

    private static void expertInfoDesensitization(List<SpecialistQuestionRecordVo> transferList) {
        if (CollUtil.isNotEmpty(transferList)) {
            transferList.forEach(t -> t.setSpecialistName(StrUtil.isBlank((CharSequence)t.getSpecialistName()) ? "" : SensitiveConverter.maskPartialData((String)t.getSpecialistName(), (int)0, (int)1)));
        }
    }

    @Generated
    public SpecialistController(ISpecialistQuestionRecordService questionRecordService, ISpecialistInfoService specialistInfoService, ISpecialistInfoProviderToSupervise specialistInfoProvider, ISpecialistQuickQuestionService questionService, IReplyTemplateService replyTemplateService) {
        this.questionRecordService = questionRecordService;
        this.specialistInfoService = specialistInfoService;
        this.specialistInfoProvider = specialistInfoProvider;
        this.questionService = questionService;
        this.replyTemplateService = replyTemplateService;
    }
}

