/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.controller.api;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.tt.framework.annotation.RequestLimit;
import cn.smarthse.tt.manage.CommonManage;
import cn.smarthse.tt.model.vo.sys.AreaVo;
import cn.smarthse.tt.model.vo.sys.EconomyVo;
import cn.smarthse.tt.model.vo.sys.IndustryDetailVo;
import cn.smarthse.tt.model.vo.sys.IndustryVo;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CommonController {
    private final CommonManage commonManage;
    private final RedisClient redisClient;

    @GetMapping(value={"/area/getAreaList"})
    public ResponseData<List<AreaVo>> getAreaList(@RequestParam(defaultValue="0") Long pid) {
        return ResponseData.success(this.commonManage.getAreaList(pid));
    }

    @GetMapping(value={"/industry/getIndustryList"})
    public ResponseData<List<IndustryDetailVo>> getIndustryList(@RequestParam(defaultValue="2478") Long pid) {
        return ResponseData.success(this.commonManage.getIndustryList(pid));
    }

    @RequestLimit(maxCount=1, second=2)
    @GetMapping(value={"/industry/search"})
    public ResponseData<List<IndustryVo>> search(String keyword) {
        return ResponseData.success(this.commonManage.searchIndustryList4(keyword));
    }

    @GetMapping(value={"/scale/getScaleList"})
    public ResponseData<CompanySizeEnum[]> getScaleList() {
        return ResponseData.success((Object)CompanySizeEnum.values());
    }

    @GetMapping(value={"/economy/getEconomyList"})
    public ResponseData<List<EconomyVo>> getEconomyList() {
        return ResponseData.success(this.commonManage.getEconomyList());
    }

    @GetMapping(value={"/autoCloseCountdown"})
    public String autoCloseCountdown(Long countdown) {
        if (countdown == null) {
            return "\u8bf7\u6307\u5b9a\u5012\u8ba1\u65f6countdown\uff08\u5355\u4f4d\uff1a\u79d2\uff09\uff01";
        }
        this.redisClient.set("auto_close_countdown", (Object)countdown);
        return "\u6210\u529f\uff0cauto_close_countdown=" + countdown;
    }

    @Generated
    public CommonController(CommonManage commonManage, RedisClient redisClient) {
        this.commonManage = commonManage;
        this.redisClient = redisClient;
    }
}

