/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.controller;

import cn.hutool.core.util.RandomUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.framework.logback.SensitiveConverter;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.zlb.PersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.modules.datacentre.provider.zlb.IZlbUserInfoProviderService;
import cn.smarthse.tt.bootstrap.security.service.LoginService;
import cn.smarthse.tt.bootstrap.security.token.LoginData;
import cn.smarthse.tt.bootstrap.security.token.ZlbCasToken;
import cn.smarthse.tt.controller.ControllerSupport;
import cn.smarthse.tt.entity.SpecialistInfo;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.manage.zlb.ZlbClientServiceService;
import cn.smarthse.tt.service.sys.ISpecialistUserService;
import cn.smarthse.tt.service.tt.ISpecialistInfoService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import jakarta.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/zlbLogin"})
@Validated
public class ZlbLoginController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbLoginController.class);
    private final LoginService loginService;
    private final ZlbClientServiceService zlbClientService;
    private final ISpecialistUserService specialistUserService;
    private final ISpecialistInfoService specialistInfoService;
    @DubboReference
    private IZlbUserInfoProviderService zlbUserInfoProviderService;
    @Value(value="${testLoginPwd}")
    private String testPwd;
    private final String CONTACT_WAY = "\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775";

    @GetMapping(value={"/userLoginTest"})
    @Log(type=1, title="\u76f4\u901a\u8f66\u6d4b\u8bd5\u767b\u5f55")
    public ResponseData<LoginData> userLoginTest(String user, String pwd) {
        if (this.testPwd == null || StringUtils.isEmpty((CharSequence)this.testPwd) || Objects.equals("false", this.testPwd)) {
            return ResponseData.fail((String)"\u7981\u6b62\u8bbf\u95ee\uff0c\u8bf7\u524d\u53bb\u767b\u5f55\uff01\uff01\uff01");
        }
        if (pwd == null || StringUtils.isEmpty((CharSequence)pwd)) {
            return ResponseData.fail((String)"\u8bf7\u8f93\u5165\u5bc6\u7801");
        }
        if (!Objects.equals(this.testPwd, pwd)) {
            return ResponseData.fail((String)"\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u524d\u53bb\u767b\u5f55\uff01\uff01\uff01");
        }
        if (user == null) {
            user = "userTest1";
        }
        log.debug("\u767b\u5f55\u6d4b\u8bd5");
        String username = "userTest1";
        String userId = "userTest1";
        String phone = "65712365";
        user = SpringEncryptUtils.encrypt((String)user);
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SpecialistInfo::getFullname, (Object)user)).eq(BaseEntity::getIsValid, (Object)true);
        SpecialistInfo dbSpecialistInfo = (SpecialistInfo)this.specialistInfoService.getOne((Wrapper)wrapper);
        if (dbSpecialistInfo != null) {
            username = dbSpecialistInfo.getFullname();
            userId = dbSpecialistInfo.getFullname();
            phone = dbSpecialistInfo.getUserMobile();
        } else {
            username = user;
            userId = user;
            phone = RandomUtil.randomNumbers((int)11);
        }
        SpecialistUser exists = this.specialistUserService.getUserByZlbUserId(userId);
        SpecialistInfo specialist = this.specialistInfoService.getSpecialistInfoByPhone(SpringEncryptUtils.encrypt((String)phone));
        if (exists == null) {
            exists = new SpecialistUser();
        } else if (exists.getIsForbidden() == 1) {
            return ResponseData.fail((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775");
        }
        exists.setUserId(userId);
        exists.setUsername(username);
        exists.setPhone(phone);
        exists.setLastLoginTime(LocalDateTime.now());
        if (specialist == null) {
            exists.setIsSpecialist(Boolean.valueOf(false));
            exists.setSpecialistId(null);
        }
        if (specialist != null && specialist.getIsEntering().booleanValue()) {
            exists.setIsSpecialist(Boolean.valueOf(true));
            exists.setSpecialistId(specialist.getId());
        } else if (specialist != null && !specialist.getIsEntering().booleanValue()) {
            return ResponseData.fail((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775");
        }
        this.specialistUserService.saveOrUpdate(exists);
        ZlbCasToken zlbCasToken = new ZlbCasToken(username, phone, userId);
        LoginData loginData = this.loginService.loginByZlbCas(zlbCasToken);
        username = SensitiveConverter.maskPartialData((String)username, (int)0, (int)1);
        loginData.setNickName(username);
        loginData.setZlbUserId(userId);
        return ResponseData.success((Object)loginData);
    }

    @PostMapping(value={"/userLogin"})
    public ResponseData<LoginData> userLogin(@NotEmpty String ticketId, @NotEmpty String appId) {
        log.debug("\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55\u7968\u636e: {}", (Object)ticketId);
        ZlbUserInfo zlbUserInfo = this.zlbClientService.getZlbUserInfo(ticketId, appId);
        if (zlbUserInfo == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01");
        }
        PersonInfo personInfo = zlbUserInfo.getPersonInfo();
        String userId = personInfo.getUserId();
        String userName = personInfo.getUserName();
        String phone = personInfo.getPhone();
        String encryptPhone = SpringEncryptUtils.encrypt((String)phone);
        log.error("\u52a0\u5bc6\u624b\u673a\u53f7\uff1a{}", (Object)encryptPhone);
        SpecialistUser exists = this.specialistUserService.getUserByZlbUserId(userId);
        SpecialistInfo specialist = this.specialistInfoService.getSpecialistInfoByPhone(encryptPhone);
        if (exists == null) {
            exists = new SpecialistUser();
        } else if (exists.getIsForbidden() == 1) {
            return ResponseData.fail((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775");
        }
        this.updateSpecialistUserInfo(exists, userId, userName, phone, specialist);
        this.specialistUserService.saveOrUpdate(exists);
        ZlbCasToken zlbCasToken = new ZlbCasToken(userName, phone, userId);
        LoginData loginData = this.loginService.loginByZlbCas(zlbCasToken);
        userName = SensitiveConverter.maskPartialData((String)userName, (int)0, (int)1);
        loginData.setNickName(userName);
        loginData.setZlbUserId(userId);
        return ResponseData.success((Object)loginData);
    }

    @Log(module=LogConstans.THROUGHTRAIN, type=1, title="\u6d59\u91cc\u529e\u7528\u6237\u5355\u70b9\u767b\u5f55")
    @PostMapping(value={"/loginByZlbV2"})
    public ResponseData<LoginData> loginByZlbV2(@NotEmpty String zlbUserId, @NotEmpty String userType) {
        log.debug("\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55 zlbUserId:{}, userType:{}", (Object)zlbUserId, (Object)userType);
        ZlbUserInfo zlbUserInfo = this.zlbUserInfoProviderService.getUserInfo(zlbUserId, userType);
        if (zlbUserInfo == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01");
        }
        PersonInfo personInfo = zlbUserInfo.getPersonInfo();
        String userId = personInfo.getUserId();
        String userName = personInfo.getUserName();
        String phone = personInfo.getPhone();
        String encryptPhone = SpringEncryptUtils.encrypt((String)phone);
        log.error("\u52a0\u5bc6\u624b\u673a\u53f7\uff1a{}", (Object)encryptPhone);
        SpecialistUser exists = this.specialistUserService.getUserByZlbUserId(userId);
        SpecialistInfo specialist = this.specialistInfoService.getSpecialistInfoByPhone(encryptPhone);
        if (exists == null) {
            exists = new SpecialistUser();
        } else if (exists.getIsForbidden() == 1) {
            return ResponseData.fail((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775");
        }
        this.updateSpecialistUserInfo(exists, userId, userName, phone, specialist);
        this.specialistUserService.saveOrUpdate(exists);
        ZlbCasToken zlbCasToken = new ZlbCasToken(userName, phone, userId);
        LoginData loginData = this.loginService.loginByZlbCas(zlbCasToken);
        userName = SensitiveConverter.maskPartialData((String)userName, (int)0, (int)1);
        loginData.setNickName(userName);
        loginData.setZlbUserId(userId);
        return ResponseData.success((Object)loginData);
    }

    @PostMapping(value={"/getZlbUserInfo"})
    public ResponseData<Map<String, String>> getZlbUserInfo(@NotEmpty String ticket, @NotEmpty String appId) {
        ZlbUserInfo zlbUserInfo = this.zlbClientService.getZlbUserInfo(ticket, appId);
        this.zlbUserInfoProviderService.saveZlbUserInfo(zlbUserInfo);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userType", zlbUserInfo.getUserType());
        if ("PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            result.put("nickName", zlbUserInfo.getPersonInfo().getUserName());
            result.put("zlbUserId", zlbUserInfo.getPersonInfo().getUserId());
        } else {
            result.put("nickName", zlbUserInfo.getLegalPersonInfo().getName());
            result.put("zlbUserId", zlbUserInfo.getLegalPersonInfo().getCorpId());
        }
        return ResponseData.success(result);
    }

    private void updateSpecialistUserInfo(SpecialistUser user, String userId, String userName, String phone, SpecialistInfo specialist) {
        user.setUserId(userId);
        user.setUsername(userName);
        user.setPhone(phone);
        user.setLastLoginTime(LocalDateTime.now());
        if (specialist == null) {
            user.setIsSpecialist(Boolean.valueOf(false));
            user.setSpecialistId(null);
            return;
        }
        if (!specialist.getIsEntering().booleanValue()) {
            throw new ServiceException("\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u4e0e\u6211\u4eec\u8054\u7cfb\uff0c\u8054\u7cfb\u65b9\u5f0f\uff1a0571-89978775");
        }
        user.setIsSpecialist(Boolean.valueOf(true));
        user.setSpecialistId(specialist.getId());
    }

    @Generated
    public ZlbLoginController(LoginService loginService, ZlbClientServiceService zlbClientService, ISpecialistUserService specialistUserService, ISpecialistInfoService specialistInfoService) {
        this.loginService = loginService;
        this.zlbClientService = zlbClientService;
        this.specialistUserService = specialistUserService;
        this.specialistInfoService = specialistInfoService;
    }
}

