/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
public class ControllerSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    protected void binderDefault(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(text.trim());
                }
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(DateUtil.parse((CharSequence)text));
                }
            }
        });
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue("true".equalsIgnoreCase(text.trim()) ? 1 : ("false".equalsIgnoreCase(text.trim()) ? 0 : Integer.parseInt(text.trim())));
                }
            }
        });
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Byte.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(new BigDecimal(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Long.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StrUtil.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Long.valueOf(text.trim()));
                }
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
    }
}

