/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.bootstrap.security.service;

import cn.smarthse.tt.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.framework.Constant;
import cn.smarthse.tt.framework.RedisKey;
import cn.smarthse.tt.service.sys.ISpecialistUserService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private final ISpecialistUserService specialistUserService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public ShiroPrincipal getLoginUser(Long userId) {
        String loginUserKey = RedisKey.getLoginUserKey(userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            SpecialistUser user = (SpecialistUser)this.specialistUserService.getById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            principal.setUser(user);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public SpecialistUser getByPhone(String phone) {
        return this.specialistUserService.getUserByPhone(phone);
    }

    public SpecialistUser getByZlbUserId(String zlbUserId) {
        return this.specialistUserService.getUserByZlbUserId(zlbUserId);
    }

    @Generated
    public TokenService(ISpecialistUserService specialistUserService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.specialistUserService = specialistUserService;
        this.redisTemplate = redisTemplate;
    }
}

