/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.bootstrap.security.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.framework.logback.SensitiveConverter;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.tt.bootstrap.properties.SysProperties;
import cn.smarthse.tt.bootstrap.security.service.ShiroUtil;
import cn.smarthse.tt.bootstrap.security.token.LoginData;
import cn.smarthse.tt.bootstrap.security.token.PasswordToken;
import cn.smarthse.tt.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.tt.bootstrap.security.token.ZlbCasToken;
import cn.smarthse.tt.entity.sys.SpecialistUser;
import cn.smarthse.tt.framework.Constant;
import cn.smarthse.tt.framework.RedisKey;
import cn.smarthse.tt.framework.utils.JwtUtil;
import cn.smarthse.tt.framework.utils.ServletUtils;
import cn.smarthse.tt.service.sys.ISpecialistUserService;
import cn.smarthse.tt.service.sys.ISysLogService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    private final ISpecialistUserService specialistUserService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final SysProperties sysProperties;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    private final ISysLogService logService;

    public LoginData loginByPassword(String username, String password, String cid) {
        try {
            Subject subject = SecurityUtils.getSubject();
            PasswordToken token = new PasswordToken(username, password, cid);
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u5bc6\u7801\u9519\u8bef\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AccountException e) {
            throw new ServiceException(e.getMessage());
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
    }

    public LoginData loginByZlbCas(ZlbCasToken token) {
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u5bc6\u7801\u9519\u8bef\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
    }

    private LoginData returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String ip = JakartaServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = this.sysProperties.getLogin().getSecret();
        String token = JwtUtil.createToken(username, userId, ip, secret, Constant.TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken(username, userId, secret, Constant.TOKEN_REFRESH_TIME);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getLoginUserKey(userId), (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        principal.getUser().setUsername(SensitiveConverter.maskPartialData((String)principal.getUser().getUsername(), (int)0, (int)1));
        principal.getUser().setPhone(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getPhone(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        principal.getUser().setUserId(null);
        principal.setUserId(principal.getUser().getId());
        principal.setUsername(SensitiveConverter.maskPartialData((String)principal.getUser().getUsername(), (int)0, (int)1));
        SysLog syslog = new SysLog();
        if (userId != null) {
            CompanyBaseInfoModel company = this.specialistUserService.getLastCompanyByUserId(userId);
            SysArea sysArea = new SysArea();
            if (company != null) {
                sysArea.setId(company.getAreaDetailId());
                sysArea.setProvinceId(company.getProvinceId());
                sysArea.setCityId(company.getCityId());
                sysArea.setAreaId(company.getAreaId());
                sysArea.setStreetId(company.getStreetId());
                syslog.setSysArea(sysArea);
                syslog.setCid(company.getCid());
            }
        }
        syslog.setUsername(ShiroUtil.getLoginUsername());
        syslog.setFullname(ShiroUtil.getLoginUsername());
        syslog.setTitle("\u6d59\u91cc\u529e\u7528\u6237\u5355\u70b9\u767b\u5f55");
        syslog.setType(Byte.valueOf((byte)1));
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        syslog.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
        Map parameterMap = request.getParameterMap();
        syslog.setParams(JSONUtil.toJsonStr((Object)parameterMap));
        syslog.setRequestUri(request.getRequestURI());
        syslog.setUserAgent(request.getHeader("user-agent"));
        syslog.setLogSource(Byte.valueOf(LogConstans.THROUGHTRAIN.getValue().byteValue()));
        syslog.setCreateDate(new Date());
        syslog.setCreateBy(userId);
        try {
            if (this.taskExecutor != null) {
                this.taskExecutor.execute(() -> this.logService.addLog(syslog));
            } else {
                this.logService.addLog(syslog);
            }
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
        }
        return new LoginData(principal, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        Long userId = JwtUtil.getUserId(refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u65e0\u6548\uff01");
        }
        SpecialistUser user = (SpecialistUser)this.specialistUserService.getById(userId);
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.sysProperties.getLogin().getSecret();
        if (!JwtUtil.verify(refreshToken, secret)) {
            throw new ServiceException("token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken(user.getUsername(), user.getId(), ip, secret, Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken(user.getUsername(), user.getId(), secret, Constant.TOKEN_REFRESH_TIME);
        return new LoginData(newToken, newRefreshToken);
    }

    public String sendVCode(String key) {
        LineCaptcha specCaptcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (int)4, (int)0);
        String code = specCaptcha.getCode().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey(key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.getImageBase64Data();
    }

    public boolean checkVCode(String key, String vcode) {
        Object vCodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
        if (Objects.isNull(vCodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode != null && vcode.equalsIgnoreCase(vCodeCache.toString());
    }

    public void logout(Long userId) {
        this.redisTemplate.delete((Object)RedisKey.getLoginUserKey(userId));
        this.redisTemplate.delete((Object)RedisKey.getForbiddenKey(userId));
    }

    public LoginData loginByUsername(String username, String phone, String zlbUserId) {
        Subject subject = SecurityUtils.getSubject();
        ZlbCasToken token = new ZlbCasToken(username, phone, zlbUserId);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            return this.returnLoginInitParam(principal);
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
    }

    @Generated
    public LoginService(ISpecialistUserService specialistUserService, StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, SysProperties sysProperties, ISysLogService logService) {
        this.specialistUserService = specialistUserService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.sysProperties = sysProperties;
        this.logService = logService;
    }
}

