/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.tt.bootstrap.security.realms;

import cn.smarthse.tt.bootstrap.security.service.TokenService;
import cn.smarthse.tt.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.tt.framework.utils.JwtUtil;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class JwtRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtRealm.class);
    @Autowired(required=false)
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof BearerToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        BearerToken bearerToken = (BearerToken)authenticationToken;
        String token = bearerToken.getToken();
        log.debug("username\uff1a{} - token auth start...", (Object)JwtUtil.getUsername(token));
        ShiroPrincipal principal = this.tokenService.getLoginUser(JwtUtil.getUserId(token));
        return new SimpleAuthenticationInfo((Object)principal, (Object)token, this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Object obj = super.getAvailablePrincipal(principals);
        if (!(obj instanceof ShiroPrincipal)) {
            return info;
        }
        ShiroPrincipal principal = (ShiroPrincipal)obj;
        info.setStringPermissions(principal.getPermissionsSet());
        info.setRoles(principal.getRoleSet());
        return info;
    }
}

