package cn.smarthse.tt.vo;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 卫企直通车问题表 Vo
 */

@Data
public class SpecialistQuickQuestionVo implements Serializable {

    private static final long serialVersionUID = 5869584706452970192L;

    /**
     * 主键id；问题id
     */
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String cname;

    /**
     * 提问人id
     */
    private Long askId;

    /**
     * 提问人名称
     */
    private String askName;
    /**
     * 专家id
     */
    private Long specialistId;
    /**
     * 回复问题的专家姓名
     */
    private String specialistName;

    /**
     * 问题标题
     */
    private String title;

    /**
     * 问题描述
     */
    private String content;

    /**
     * 问题文件；文件id，若多个逗号分隔
     */
    private String file;
    private List<SysFileModel> fileList;

    /**
     * 问题类型/擅长领域（单选）；参考SpecialistExpertiseAreaEnum
     */
    private Integer type;

    /**
     * 问题类型/擅长领域 名称
     */
    private String typeName;

    /**
     * 问题状态：1-未完成，2-已完成，3-已无效，4-待响应，5-未响应
     */
    private Integer status;
    /**
     * 专家接收问题的状态：1-未完成，2-已完成，3-已无效，4-待响应，5-未响应，6-已移交（专业领域不符合），7-已移交（无法回答），8-被移交（其他专家移交给当前专家），
     * 9-超时响应（响应超时移交到当前专家）
     */
    private Integer questionStatus;
    /**
     * 是否超时移交
     */
    private Boolean isNoResponse;
    /**
     * 移交类型（1-专家手动移交，2-超时移交，系统自动移交）
     */
    private Integer transferType;

    /**
     * 移交问题的专家id
     */
    private Long transferSpecialistId;

    /**
     * 问题状态名称
     */
    private String statusName;

    /**
     * 最新的交流信息，是否用户回复
     */
    private Boolean userReply;

    /**
     * 最新的交流信息，是否专家回复
     */
    private Boolean expertReply;

    /**
     * 最新的交流信息，是否已读（true未读 false已读）
     */
    private Boolean latestReplyNoRead;

    /**
     * 问题是否：被移交
     */
    private Boolean isTransfer;

    /**
     * 问题是否：被移交 且 被移交的专家对问题进行了回复
     */
    private Boolean isTransferAndReply;

    /**
     * 最新的回复时间
     */
    private Date replyTime;

    /**
     * 问题属性（1-智能匹配，2-用户指定）
     */
    private Byte property;

    /**
     * 记录专家最后一次回复时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastReplyTime;

    /**
     * 根据专家最后一次回复时间，计算问题自动关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime autoCloseTime;

    /**
     * 是否有效；0无效1有效
     */
    private Boolean isValid;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 提出问题时间相对于现在的时间，刚刚/XX分钟前/XX小时前/XX天前。
     */
    private String relativeTime;

    /**
     * 修改人id
     */
    private Long updatedBy;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 未响应的截止时间，根据改时间进行倒计时
     */
    @ApiModelProperty("未响应的截止时间，根据该时间进行倒计时")
    private Date noResponseTime;

    /**
     * 运维专家回复
     */
    @ApiModelProperty("运维专家回复")
    private Boolean maintenanceReply;

    @ApiModelProperty("是否为历史记录（0-否，1-是）")
    private Boolean isHistory;
}
