package cn.smarthse.tt.vo;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卫企直通车交流表 Vo
 */

@Data
public class SpecialistQuickCommunicateVo implements Serializable {

    private static final long serialVersionUID = -984039560161203067L;

    /**
     * 主键id；交流id
     */
    private Long id;

    /**
     * 企业id（个人用户提问时选的这个cid，基于此cid进行的交流回复）
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String cname;

    /**
     * 问题id；quick_question.id
     */
    private Long questionId;

    /**
     * 专家id（specialist_info.id），从问题列表跳过来的那个专家的id，也表示此回复归属于此专家。
     */
    private Long specialistId;

    /**
     * 回复专家，头像照片文件ID，specialist_info.face_id
     */
    private Long faceId;

    /**
     * 回复专家头像文件
     */
    private SysFileModel faceFile;

    /**
     * 类型；0系统消息1用户回复2专家回复
     */
    private Integer type;

    /**
     * 回复人员id（用户或专家）
     */
    private Long personId;

    /**
     * 回复人员姓名（用户或专家）
     */
    private String personName;

    /**
     * 交流内容
     */
    private String content;

    /**
     * 是否有效；0无效1有效
     */
    private Boolean isValid;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 修改人id
     */
    private Long updatedBy;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 回复是否已收藏，true-已收藏
     */
    private Boolean isCollect;

}
