package cn.smarthse.tt.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SpecialistQuestionRecordVo
 * @Description 专家，问题关联记录
 * @Author 曾华川
 * @Date 2024年05月20日 15:45
 **/
@Data
public class SpecialistQuestionRecordVo implements Serializable {

    private static final long serialVersionUID = 1849712879357767954L;
    private Long id;

    @ApiModelProperty("问题表id")
    private Long questionId;

    @ApiModelProperty("移交问题的专家id")
    private Long transferSpecialistId;

    @ApiModelProperty("接收问题的专家id")
    private Long receiveSpecialistId;

    @ApiModelProperty("是否为历史记录（0-否，1-是）")
    private Boolean isHistory;

    @ApiModelProperty("移交类型（1-专家手动移交，2-超时移交，系统自动移交")
    private Integer transferType;

    @ApiModelProperty("移交原因的类别（1-不符合专业领域，2-无法回答）")
    private Integer reasonType;

    @ApiModelProperty("专家领域类型（枚举）")
    private Integer specialistFieldType;
    private String specialistFieldTypeStr;

    @ApiModelProperty("移交理由")
    private String reason;

    /**
     * 未响应的截止时间，根据改时间进行倒计时
     */
    @ApiModelProperty("未响应的截止时间，根据该时间进行倒计时")
    private Date noResponseTime;

    /**
     * 专家问题的状态：1-未完成，2-已完成，3-已无效，4-待响应，5-未响应，6-已移交（专业领域不符合），7-已移交（无法回答），8-被移交（其他专家移交给当前专家），
     * 9-超时响应（响应超时移交到当前专家）
     */
    @TableField("question_status")
    private Integer questionStatus;

    @ApiModelProperty("更新时间")
    private Date updateDate;

    @ApiModelProperty("专家姓名")
    private String specialistName;

    /**
     * 提问人姓名
     */
    private String askName;

    @ApiModelProperty("问题状态-1未完成 2已完成 3已无效 4待响应 5未响应")
    private Byte status;

    /**
     * 专家是否 已响应
     */
    private Boolean isResponse;

    /**
     * 显示内容 0-创建问题，1-问题分配至，2-问题未响应，3-问题移交至，4-问题已完成，5-问题已无效
     */ @ApiModelProperty("显示内容 0-创建问题，1-问题分配至，2-问题未响应，3-问题移交至，4-问题已完成，5-问题已无效")
    private Integer content;

    /**
     * 问题创建时间
     */
    private Date questionDate;
}
