package cn.smarthse.tt.vo;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 根据区域统计问题响应情况
 * @Title: SpecialistAnswerCount
 * @Author zhangt
 * @Date: 2024/5/28 19:18
 */
@Data
@ApiModel
public class SpecialistQuestionCount extends BaseEntity {

    @ApiModelProperty("区域ID")
    private Long areaId;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("问题ID")
    private Long questionId;

    @ApiModelProperty("是否未响应")
    private Boolean noResponseStatus;

    /**
     * 是否有人响应
     * 用于查询未响应的问题 在该区域中是否有人响应过这个问题
     */
    private Boolean responseStatus;

}
